<?php
session_start();
require_once('../../../../functions.php');
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Content-Type: application/json');

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pedido_online');
$arrayParam = '';

$documento = $_GET['documento'];

$sql = "SELECT
        p.*,
        c.xNome,
        c.xBairro,
        c.xLgr,
        c.nro,
        c.xCpl,
        COALESCE(c.whatsapp, c.fone, c.fone1) as cliente_telefone
    FROM pedido_online p
    LEFT JOIN cliente c ON p.cliente = c.clienteid
    WHERE p.documento = '$documento'
";

// echo $sql;
// die;

$pedido = $crud->getSQLGeneric($sql, $arrayParam, false);

if (!$pedido) {
    throw new Exception('Pedido não encontrado');
}

// Buscar itens do pedido
$sqlItens = "SELECT 
    i.*,
    p.descricao as produto_descricao,
    (i.quantidade * i.valorliquido) as subtotal
FROM itens_pedido_online i
LEFT JOIN produtos p ON i.produto = p.codigo
WHERE i.documento = '$documento'";

// echo $sqlItens;
// die;

$itens = $crud->getSQLGeneric($sqlItens, $arrayParam, true);

// Montar resposta
$response = [
    'status' => 'OK',
    'cliente' => [
        'nome' => $pedido->xNome,
        'telefone' => $pedido->cliente_telefone,
    ],
    'entrega' => [
        'endereco' => $pedido->xLgr,
        'bairro' => $pedido->xBairro,
        'observacoes' => $pedido->xCpl,
        'numero' => $pedido->nro
    ],
    'obs' => $pedido->obs,
    'tipo_entrega' => $pedido->tipo_entrega,
    'itens' => array_map(function($item) {
        return [
            'descricao' => $item->produto_descricao,
            'quantidade' => $item->quantidade,
            'valor_unitario' => number_format((float)$item->valorliquido, 2, ',', '.'),
            'subtotal' => number_format((float)$item->subtotal, 2, ',', '.')
        ];
    }, $itens),
    'total' => number_format((float)$pedido->valortotal, 2, ',', '.')
];

echo json_encode($response);
