<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";
require_once "../../_class/parametros.php";
require_once "../../../_fiscal/_ibpt/bootstrap.php";

use NFePHP\Ibpt\Ibpt;

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}

function Retornavalor($valor, $retorno, $desc) {
    if ($valor > 0) :
        return ($retorno - $desc);
    else :
        return 0;
    endif;
}

function RetornaImp($p, $b, $desc) {
    if ($p > 0) :
        $b = $b - $desc;
        return $imposto = $b * ($p / 100);
    else :
        return 0;
    endif;
}

function BuscaPara($valor, $id) {
    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from fornecedor where fornecedorid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao_dev_ent where documento = " . $_GET['documento'] . "";
$arrayParam = '';
$movimentacao_dev_ent = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

if ($movimentacao_dev_ent->para == 'R') :
    $id = $movimentacao_dev_ent->representante;
    $dest = BuscaPara('R', $movimentacao_dev_ent->representante);
elseif ($movimentacao_dev_ent->para == 'F') :
    $id = $movimentacao_dev_ent->fornecedor;
    $dest = BuscaPara('F', $movimentacao_dev_ent->fornecedor);
else :
    $id = $movimentacao_dev_ent->cliente;
    $dest = BuscaPara('C', $movimentacao_dev_ent->cliente);
endif;

$dest = limpar_dados($dest);

$pdo = Conexao::getInstance();
$crud = Crud:: getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovimentacao_dev_ent where documento = '" . $_GET['documento'] . "' and cancelado = 'N' ORDER BY item ASC";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT nNF FROM nfe where empresa = '" . $_SESSION['Empresa'] . "' and modelo = '55' and tipo = 'Saida' ORDER BY nNF Desc LIMIT 1";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
$nNF = $dados->nNF + 1;

$nfe = array(
    "natOp" => 'Devolução de entrada',
    "indPag" => '2',
    "modelo" => '55',
    "serie" => '1',
    "nNF" => $nNF,
    "dhEmi" => $movimentacao_dev_ent->data,
    "hEmi" => $movimentacao_dev_ent->hora,
    "dhSaiEnt" => $movimentacao_dev_ent->data,
    "hSaiEnt" => $movimentacao_dev_ent->hora,
    "indPag" => '2',
    "tpEmis" => '1',
    "finNFe" => '4',
    "indPres" => '1',
    "tpNF" => '1',
    "modFrete" => '9',
    "empresa" => $_SESSION['Empresa'],
    "emitente" => $_SESSION['Empresa'],
    "tipo" => 'Saida'
);

//
$cliente = array(
    "destCNPJ" => $dest->CNPJ,
    "destIE" => $dest->IE,
    "destxNome" => $dest->xNome,
    "destCEP" => $dest->CEP,
    "destxLgr" => $dest->xLgr,
    "destnro" => $dest->nro,
    "destxBairro" => $dest->xBairro,
    "destxMun" => $dest->xMun,
    "destcMun" => $dest->cMun,
    "destUF" => $dest->UF,
    "destfone" => $dest->fone
);

$total = array(
    "vBCSTnf" => '0',
    "vSTnf" => '0',
    "vProdnf" => $movimentacao_dev_ent->valortotal,
    "vFretenf" => '0',
    "vSegnf" => '0',
    "vDescnf" => $movimentacao_dev_ent->desconto,
    "vIInf" => '0',
    "vIPInf" => '0',
    "vPISnf" => '0',
    "vCOFINSnf" => '0',
    "vOutronf" => '0',
    "vNF" => number_format($movimentacao_dev_ent->valortotal - $movimentacao_dev_ent->desconto, 2, '.', '')
);

$insnfe = array_merge($nfe, $cliente, $total);
$filternfe = array_filter($insnfe);

$total = count($filternfe);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = $crud->SQLinsert('nfe', $filternfe, $total);
$retorno = $crud->SqlID($sql);
//echo $sql;
$nfeid = $retorno;

$totalprod = count($produtos);
$totalitemdesc = count($produtos);

if ($movimentacao_dev_ent->desconto > '0') :
    $proddesc = $movimentacao_dev_ent->desconto / $totalprod;
endif;
$vDesc = 0;
$tdesconto = 0;
$item = 1;

foreach ($produtos as $prod) :


    if (isset($proddesc)) :
        if ($item == $totalitemdesc) :
            if ($tdesconto > 0) :
                $vDesca = $movimentacao_dev_ent->desconto - $tdesconto;
                $vDesc = number_format($vDesca, 2, '.', '');
            else :
                $vDesc = $movimentacao_dev_ent->desconto;
            endif;
        else :
            $vDesc = number_format($proddesc, 2, '.', '');
            $tdesconto = $tdesconto + $vDesc;
        endif;
    else :
        $vDesc = 0;
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'itmovsai');
    $sql = "SELECT produto, codproduto from estoqueprodutos where codproduto = '$prod->produto'";
    $arrayParam = '';
    $estoqueproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $proddados = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (count($proddados) > 0) :
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud:: getInstance($pdo, 'itmovsai');
        $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '1'";
        $arrayParam = '';
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    echo $sql;




    if ($proddados->tributacaotipo === 'O') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from produtos_icms WHERE produto = '" . $estoqueproduto->produto . "' and uf = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from fiscalicmsinterestadual WHERE origem = '" . $emitente->UF . "' and destino = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
    endif;

//    print_r($produtos_icms);

    if ($emitente->UF != $dest->UF) :
        $cfop = $emitente->cfopdevolucaouf;
    else :
        $cfop = $emitente->cfopdevolucao;
    endif;
    if ($produtos_icms->icms > 4) :
        $origem = '0';
    else :
        $origem = '1';
    endif;
    $produtonfe = array(
        "cProd" => $prod->produto,
        "NFe" => $nfeid,
        "xProd" => $proddados->descricao,
        "uCom" => $proddados->unidade,
        "vProd" => $prod->preco,
        "NCM" => $proddados->ncm,
        "CST" => $proddados->cst,
        "modBC" => $proddados->modBC,
        "qtd" => $prod->quantidade,
        "valortotal" => $prod->valorbruto,
        "orig" => $origem,
        "CFOP" => $cfop,
        "vDesc" => $vDesc
    );
//    echo $proddados->pICMS;
    if ($proddados->tributado == 'S') :
        $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc);
        $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc);
        $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc);
        $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc);
        $prodnfeimp = array(
            "pICMS" => $produtos_icms->icms,
            "vBC" => Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc),
            "vICMS" => RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc),
            "pRedBC" => "0",
            "CSTIPI" => $proddados->cstipi,
            "pIPI" => $proddados->pIPI,
            "vBCIPI" => Retornavalor($proddados->pIPI, $prod->valorbruto, $vDesc),
            "vIPI" => RetornaImp($proddados->pIPI, $prod->valorbruto, $vDesc),
            "CSTPIS" => $proddados->cstpis,
            "pPIS" => $proddados->pPIS,
            "vBCPIS" => Retornavalor($proddados->pPIS, $prod->valorbruto, $vDesc),
            "vPIS" => RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc),
            "CSTCOFINS" => $proddados->cstcofins,
            "pCOFINS" => $proddados->vCOFINS,
            "vBCCOFINS" => Retornavalor($proddados->vCOFINS, $prod->valorbruto, $vDesc),
            "vCOFINS" => RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc),
        );
    else :
        $vBCICMS = $vBCICMS + 0;
        $vICMS = $vICMS + 0;
        $vPIS = $vPIS + 0;
        $vCOFINS = $vCOFINS + 0;
        $prodnfeimp = array(
            "CSTIPI" => $proddados->cstipi,
            "CSTPIS" => $proddados->cstpis,
            "CSTCOFINS" => $proddados->cstcofins,
        );
    endif;

    if ($emitente->tokenibpt != '') :
        $token = $emitente->tokenibpt;
        $cnpj = $emitente->CNPJ;

        $ncm = $proddados->ncm; //coloque o NCM do produto
        $uf = $emitente->UF; //coloque o estado que deseja saber os dados
        $extarif = 0; //indique o numero da exceção tarifaria, se existir ou deixe como zero
        $codigoInterno = '';
        $descricao = $proddados->descricao;
        $unidadeMedida = $proddados->unidade;
        $valor = $prod->valorbruto;
        $gtin = 'SEM GTIN';
        $ibpt = new Ibpt($cnpj, $token);

        $resp = $ibpt->productTaxes(
                $uf, $ncm, $extarif, $descricao, $unidadeMedida, $valor, $gtin, $codigoInterno
        );

//        $_POST['vTotTrib'] = $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal;
//
//        $_POST['tribFederal'] = $resp->ValorTributoNacional;
//        $_POST['tribEstadual'] = $resp->ValorTributoEstadual;
//        $_POST['tribMunicipal'] = $resp->ValorTributoMunicipal;

        $tribaprox = array(
            "tribFederal" => $resp->ValorTributoNacional,
            "tribEstadual" => $resp->ValorTributoEstadual,
            "tribMunicipal" => $resp->ValorTributoMunicipal,
            "vTotTrib" => $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal
        );
    else :
        $tribaprox = array(
            "tribFederal" => '0',
            "tribEstadual" => '0',
            "tribMunicipal" => '0',
            "vTotTrib" => '0'
        );
    endif;

    $prodnfe = array_merge($produtonfe, $prodnfeimp, $tribaprox);
//    $prodnfe = array_filter($prodnfe);

    $total = count($prodnfe);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = $crud->SQLinsert('produtonfe', $prodnfe, $total);
    $retorno = $crud->Sql($sql);

//    echo $sql;
//    echo '<pre>';
//    print_r($prodnfe);
//    echo '</pre>';
    $item++;
endforeach;

$item = 1;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update nfe set vBCnf = '$vBCICMS', vICMSnf = '$vICMS', vPISnf = '$vPIS', vCOFINSnf = '$vCOFINS' where id = '$nfeid' ";
$retorno = $crud->Sql($sql);

//echo $sql;

if ($nfeid > 0) :
    $arr = array("nfe" => $nNF, "mensagem" => 'NF-e Gerada com sucesso! Nº ' . $nNF . '');
else :
    $arr = array("nfe" => 0, "mensagem" => "Não foi possivél gerar a NF-e");
endif;

echo json_encode($arr);
