<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

// Garante sessão iniciada (PHP 8.1+)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

date_default_timezone_set('America/Sao_Paulo');
$datadia = date("d/m/Y");

//print_r($_POST);

$hora    = date('H:i');
$usuario = $_SESSION['UsuarioID'] ?? null; // evita notice se não existir

function BuscaTransp($valor) {
    $pdo  = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'orcamento');
    $sql  = "SELECT * from transportador WHERE transportadorid = '$valor'";
    $arrayParam   = '';
    $transportador = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $transportador->xNome ?? '';
}

function Valor($valor) {
    $verificaPonto = ".";
    if (strpos("[" . $valor . "]", "$verificaPonto")):
        $valor = str_replace('.', '', $valor);
        $valor = str_replace(',', '.', $valor);
    else:
        $valor = str_replace(',', '.', $valor);
    endif;

    return $valor;
}

// Normaliza POST (evita warnings no PHP 8.2)
$_POST['dinheiro'] = str_replace(',', '.', $_POST['dinheiro'] ?? 0);
$_POST['cc']       = str_replace(',', '.', $_POST['cc'] ?? 0);
$_POST['cd']       = str_replace(',', '.', $_POST['cd'] ?? 0);
$_POST['np']       = str_replace(',', '.', $_POST['np'] ?? 0);
$_POST['px']       = str_replace(',', '.', $_POST['px'] ?? 0);

$valortotal = $_POST['isubtotalps'] ?? 0;

$valorpago = ($_POST['dinheiro'] ?? 0)
           + ($_POST['cc']       ?? 0)
           + ($_POST['cd']       ?? 0)
           + ($_POST['np']       ?? 0)
           + ($_POST['px']       ?? 0);

$frete     = $_POST['vrfrete']    ?? 0;
$documento = $_POST['documentof'] ?? '';
$credito   = str_replace(',', '.', $_POST['creditops'] ?? 0);
//echo $frete;
//print_r($_POST);

$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'orcamento');
$sql  = "SELECT * from orcamento WHERE documento = '$documento'";
$arrayParam = '';
$orcamento  = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$docempresa = $orcamento->doc_empresa ?? '';

if (!empty($orcamento->cliente)) :
    $para   = 'cliente';
    $paraid = $orcamento->cliente;

elseif (!empty($orcamento->representante)) :
    $para   = 'representante';
    $paraid = $orcamento->representante;

elseif (!empty($orcamento->funcionario)) :
    $para   = 'funcionario';
    $paraid = $orcamento->funcionario;
endif;

$valortotal = Valor($valortotal);

// Garante arrays para não dar erro no PHP 8.2
$datap  = $_POST['datap']  ?? [];
$tipop  = $_POST['tipop']  ?? [];
$valorp = $_POST['valorp'] ?? [];

// Protege o count() no PHP 8.2
$totalparcela = is_countable($datap) ? count($datap) : 0;

$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'recebimentoorc');
$sql  = "delete from recebimentoorc WHERE documento = '$documento'";
//echo $sql;
$retorno = $crud->Sql($sql);

$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'recebimentoorc');
$sql  = "UPDATE orcamento set hora = '$hora', valortotal = '$valortotal', valorpago = '$valorpago', troco ='" . ($_POST['troco'] ?? 0) . "',
    desconto = '" . ($_POST['vrdescontops'] ?? 0) . "', situacao = 'F', frete = '$frete'";

if ($credito > 0) :
    $sql .= " , utilizadocredito = 'S', credito = '$credito'";
endif;

$sql .= " WHERE documento = '$documento' ";
//echo $sql;
$retorno = $crud->Sql($sql);
$id      = $documento;

//$retorno = false;
if ($retorno) :
    $msg  = 'OK';
    $data = $orcamento->data ?? $datadia;

    $clausula = $para . 'id';
    $pdo      = Conexao::getInstance();
    $crud     = Crud::getInstance($pdo, 'orcamento');
    $sql      = "SELECT * from $para WHERE $clausula = '$paraid'";
    $arrayParam = '';
    $repre      = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    // ATENÇÃO: $data1 não está definido neste script, mantido como no original
    // para não alterar regra. Verificar depois se precisar.
    $datavenc = date("Y-m-d", strtotime(($data1 ?? date('Y-m-d')) . ' + 30 days'));
    if (function_exists('parseDate')) {
        $datavenc = parseDate($datavenc, "d/m/Y");
    } else {
        $datavenc = date("d/m/Y", strtotime($datavenc));
    }

    if (!empty($orcamento->controle)) :
        $titulo = $orcamento->controle;
    else :
        $titulo = $id;
    endif;

    $parcela = '1';

    if ($_POST['dinheiro'] > 0) :
        $data = date("d/m/Y");

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'recebimentoorc');
        $sql  = "INSERT INTO recebimentoorc(documento, dataven, tiporeceb, valor) 
            VALUES
            ('$documento', '$data', 'D', '" . $_POST['dinheiro'] . "')
            ";
        $retorno = $crud->Sql($sql);
//        echo $sql;
    endif;

    if ($_POST['px'] > 0) :
        $data = date("d/m/Y");

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'recebimentoorc');
        $sql  = "INSERT INTO recebimentoorc(documento, dataven, tiporeceb, valor) 
            VALUES
            ('$documento', '$data', 'PX', '" . $_POST['px'] . "')
            ";
        $retorno = $crud->Sql($sql);
//        echo $sql;
    endif;

    if ($_POST['cc'] > 0) :
        $situacao = 'A';

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'recebimentoorc');
        $sql  = "INSERT INTO recebimentoorc(documento, dataven, tiporeceb, valor) 
            VALUES
            ('$documento', '$datavenc', 'CC', '" . $_POST['cc'] . "')
            ";
        $retorno = $crud->Sql($sql);
    endif;

    if ($_POST['cd'] > 0) :
        $situacao = 'A';

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'recebimentoorc');
        $sql  = "INSERT INTO recebimentoorc(documento, dataven, tiporeceb, valor) 
            VALUES
            ('$documento', '$datavenc', 'CD', '" . $_POST['cd'] . "')
            ";
        $retorno = $crud->Sql($sql);
    endif;

    if ($_POST['np'] > 0) :
        $situacao = 'A';

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'recebimentoorc');
        $sql  = "INSERT INTO recebimentoorc(documento, dataven, tiporeceb, valor) 
            VALUES
            ('$documento', '$datavenc', 'NP', '" . $_POST['np'] . "')
            ";
        $retorno = $crud->Sql($sql);
    endif;

else :
    $msg     = 'Houve um Erro ao criar o Documento, tente novamente!';
    $retorno = -1;
endif;

//echo '..';
$exec = array(
    "mensagem" => $msg,
    "retorno"  => $retorno,
    "doc"      => $documento
);
echo json_encode($exec);
