<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

// Garante que sessão esteja iniciada, se você usar $_SESSION aqui em algum momento
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Garante que as variáveis de POST existam e sejam arrays onde esperado
$chavenfe = isset($_POST['chavenfe']) && is_array($_POST['chavenfe']) ? $_POST['chavenfe'] : [];
$ncf      = isset($_POST['ncf'])      && is_array($_POST['ncf'])      ? $_POST['ncf']      : [];
$ncoo     = isset($_POST['ncoo'])     && is_array($_POST['ncoo'])     ? $_POST['ncoo']     : [];
$modelo   = isset($_POST['modelocf']) && is_array($_POST['modelocf']) ? $_POST['modelocf'] : [];

// guarda id em variável e evita notice se não existir
$id = isset($_POST['id']) ? $_POST['id'] : '';

// remove campos que não pertencem diretamente à tabela nfe
unset($_POST['chavenfe'], $_POST['ncf'], $_POST['ncoo'], $_POST['modelocf']);

// valida id
if ($id === '') :
    $exec = array("mensagem" => 'É necessário pelo menos um produto.', "retorno" => false);
    echo json_encode($exec);
    exit;
endif;

// Consumindo métodos do CRUD genérico 
$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');

// atualiza nfe
$arrayCond = array('id=' => $id);
$retorno   = $crud->update($_POST, $arrayCond);

require_once "../../_class/parametros.php";

// valida fatura se parametrizado
if (isset($parametros->bloq_fat) && $parametros->bloq_fat === 'S') :
    $pdo  = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'cfnfe');
    $sql  = 'SELECT * FROM duplicatanfe WHERE nfe = "' . $id . '"';
    $arrayParam = [];
    $prodnfe = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (!is_array($prodnfe)) {
        $prodnfe = [];
    }

    $totalprod = count($prodnfe);
    if ($totalprod <= 0) :
        $exec = array("mensagem" => 'Nota Fiscal sem FATURA!', "retorno" => false);
        echo json_encode($exec);
        exit;
    endif;
endif;

// valida se tem pelo menos um produto
$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cfnfe');
$sql  = 'SELECT * FROM produtonfe WHERE NFe = "' . $id . '"';
$arrayParam = [];
$prodnfe = $crud->getSQLGeneric($sql, $arrayParam, true);

if (!is_array($prodnfe)) {
    $prodnfe = [];
}

$totalprod = count($prodnfe);
if ($totalprod <= 0) :
    $exec = array("mensagem" => 'É necessário pelo menos um produto.', "retorno" => false);
    echo json_encode($exec);
    exit;
endif;

// limpa vínculos anteriores
$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfenfe');
$sql  = 'DELETE FROM nfenfe WHERE nNF = "' . $id . '"';
$retorno = $crud->Sql($sql);

$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'cfnfe');
$sql  = 'DELETE FROM cfnfe WHERE nNF = "' . $id . '"';
$retorno = $crud->Sql($sql);

if (!$retorno) :
    $msg     = 'Houve um Erro ao cadastrar a Nota Fiscal, tente novamente!';
    $retorno = -1;
else :
    $msg = 'Nota Fiscal Cadastrado com SUCESSO!';

    // grava chaves nfenfe
    $nchavenfe = count($chavenfe);
    for ($i = 0; $i < $nchavenfe; $i++) :

        if (!isset($chavenfe[$i])) {
            continue;
        }

        $dadoschavenfe = array(
            "chavenfe" => $chavenfe[$i],
            "nNF"      => $id
        );

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'nfenfe');
        $total = count($dadoschavenfe);
        $sql   = $crud->SQLinsert('nfenfe', $dadoschavenfe, $total);
        $crud->Sql($sql);

    endfor;

    // grava cupons cfnfe
    $nncf = count($ncf);
    for ($i = 0; $i < $nncf; $i++) :

        if (!isset($ncf[$i], $ncoo[$i], $modelo[$i])) {
            continue;
        }

        $dadoscf = array(
            "ncf"    => $ncf[$i],
            "ncoo"   => $ncoo[$i],
            "modelo" => $modelo[$i],
            "nNF"    => $id
        );

        $pdo  = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'cfnfe');
        $total = count($dadoscf);
        $sql   = $crud->SQLinsert('cfnfe', $dadoscf, $total);
        $crud->Sql($sql);

    endfor;
endif;

$exec = array("mensagem" => $msg, "retorno" => $retorno);
echo json_encode($exec);
