<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");
require_once("../../../../_backend/_class/status_class.php");

function Para($valor) {
    if ($valor == 'R') :
        return 'Representante';
    elseif ($valor == 'F') :
        return 'Funcionário';
    else :
        return 'Cliente';
    endif;
}

function Situacao($valor) {
    if ($valor == 'A') :
        return 'Aberta';
    elseif ($valor == 'C') :
        return 'Cancelada';
    else :
        return 'Fechada';
    endif;
}

function Tipo($valor) {
    if ($valor == 'S') :
        return 'Direta';
    elseif ($valor == 'R') :
        return 'S.Remessa';
    elseif ($valor == 'O') :
        return 'Orçamento';
    else :
        return 'Consignada';
    endif;
}

function formatarSituacao($valor) {
    if ($valor == 'A') :
        return '<label class="label label-warning" style="font-size: 95%;"> Aberta </label>';
    elseif ($valor == 'C') :
        return '<label class="label label-danger" style="font-size: 95%;"> Cancelada </label>';
    elseif ($valor == 'E') :
        return '<label class="label label-info" style="font-size: 95%;"> Em preparo </label>';
    elseif ($valor == 'S') :
        return '<label class="label label-primary" style="font-size: 95%;"> Saiu para entrega </label>';
    else :
        return '<label class="label label-success" style="font-size: 95%;"> Finalizado </label>';
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao');


// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
    0 => 'documento',
    1 => 'documento',
    2 => 'data',
    3 => 'cliente',
    4 => 'valor',
    5 => 'situacao',
    6 => 'tipo',
    7 => 'imprimir'
);

$sql = "SELECT 
        po.documento,
        po.cliente,
        cliente.xNome,
        po.valortotal,
        po.situacao,
        po.data,
        po.tipo_entrega,
        mo.doc_empresa AS venda
        from pedido_online po
        LEFT JOIN cliente ON cliente.clienteid = po.cliente
        LEFT JOIN movimentacao mo ON mo.pedido_online = po.documento
        where po.situacao != 'P' and po.empresa = '1'";

$arrayParam = '';

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND po.documento LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND po.data LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND cliente.xNome LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND po.valortotal LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND po.situacao LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND po.tipo_entrega LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND mo.doc_empresa LIKE '%" . $requestData['columns'][7]['search']['value'] . "%'";
}

$dataInicial = isset($requestData['dataInicial']) ? $requestData['dataInicial'] : '';
$dataFinal = isset($requestData['dataFinal']) ? $requestData['dataFinal'] : '';

if (!empty($dataInicial) && !empty($dataFinal)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') BETWEEN str_to_date('$dataInicial', '%d/%m/%Y') AND str_to_date('$dataFinal', '%d/%m/%Y') ";
} elseif (!empty($dataInicial)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') >= str_to_date('$dataInicial', '%d/%m/%Y') ";
} elseif (!empty($dataFinal)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') <= str_to_date('$dataFinal', '%d/%m/%Y') ";
}

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY po.documento DESC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

// echo $sql;
// die;

$total = 0;
$data = array();
foreach ($dados as $movimentacao) {
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $movimentacao->documento . "' onclick=' SetSel(this);' />";
    $nestedData[] = $movimentacao->documento;
    $nestedData[] = $movimentacao->data;
    $nestedData[] = $movimentacao->xNome;
    $nestedData[] = $movimentacao->valortotal;
    $nestedData[] = formatarSituacao($movimentacao->situacao);

    if($movimentacao->tipo_entrega == 'E') {
        $nestedData[] = '<label class="label label-warning" style="font-size: 95%;"> Entrega </label>';
    } else {
        $nestedData[] = '<label class="label label-primary" style="font-size: 95%;"> Retirada </label>';
    }

    $nestedData[] = $movimentacao->venda;

    $total = $total + $movimentacao->valortotal;
    
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);


//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
