<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");

function Para($valor) {
    if ($valor == 'R') :
        return 'Representante';
    elseif ($valor == 'F') :
        return 'Funcionário';
    else :
        return 'Cliente';
    endif;
}

function Situacao($valor) {
    if ($valor == 'A') :
        return 'Aberta';
    elseif ($valor == 'C') :
        return 'Cancelada';
    else :
        return 'Fechada';
    endif;
}

function Tipo($valor) {
    if ($valor == 'S') :
        return 'Direta';
    elseif ($valor == 'R') :
        return 'S.Remessa';
    elseif ($valor == 'O') :
        return 'Orçamento';
    else :
        return 'Consignada';
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'orcamento');


// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_orcamento',
    1 => 'doc_empresa',
    2 => 'data',
    3 => 'para',
    4 => 'cliente',
    5 => 'valor',
    6 => 'situacao',
    7 => 'tipo',
    8 => 'documento'
//    8 => 'aprovado'
);


$sql = "select orcamento.`documento`, orcamento.data, orcamento.aprovado, orcamento.hora, orcamento.para,orcamento.vendedor, 
orcamento.`representante`, orcamento.cliente, orcamento.funcionario,orcamento.troco, orcamento.motivocancelado,
orcamento.`valorpago`, orcamento.`valortotal`,  orcamento.`tipo`, orcamento.situacao, orcamento.empresa, orcamento.doc_empresa,
`representante`.`representanteid`, `representante`.`xNome` as xNomeR, representante.`xFant` as xFantR, 
cliente.`clienteid`, cliente.`xNome` as xNomeC, cliente.`xFant` as xFantC, 
funcionario.`funcionarioid`, funcionario.`xNome` as xNomeF, funcionario.`xFant` as xFantF
From `orcamento`
LEFT JOIN `representante` ON `representante`.`representanteid` = `orcamento`.`representante`
LEFT JOIN cliente ON `cliente`.`clienteid` = `orcamento`.`cliente`
LEFT JOIN funcionario on `funcionario`.`funcionarioid` = `orcamento`.`funcionario` ";
$arrayParam = '';
$sql .= " WHERE 1=1 AND orcamento.empresa = '" . $_SESSION['Empresa'] . "'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND doc_empresa LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND data LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND para LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND ((representante.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR (cliente.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%') OR (funcionario.`xNome` LIKE '%" . $requestData['columns'][4]['search']['value'] . "%')) ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND valorpago LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND situacao LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND orcamento.tipo = '" . $requestData['columns'][7]['search']['value'] . "' ";
}


//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY doc_empresa DESC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$total = 0;
$data = array();
foreach ($dados as $orcamento) {
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $orcamento->documento . "' onclick=' SetSel(this);' />";
    $nestedData[] = $orcamento->doc_empresa;
    $nestedData[] = $orcamento->data;
    $nestedData[] = Para($orcamento->para);
    if ($orcamento->situacao == 'C') :
        $nestedData[] = $orcamento->xNomeR . $orcamento->xNomeC . $orcamento->xNomeF . '  <b>(' . $orcamento->motivocancelado . ') </b>';
    else :
        $nestedData[] = $orcamento->xNomeR . $orcamento->xNomeC . $orcamento->xNomeF;
    endif;
    $total = $total + ($orcamento->valortotal - $orcamento->desconto);
    $nestedData[] = 'R$ ' . number_format($orcamento->valortotal - $orcamento->desconto, $parametros->casadecimal, ',', '.');
    $nestedData[] = Situacao($orcamento->situacao);
    $nestedData[] = Tipo($orcamento->tipo);
//    $nestedData[] = Tipo($orcamento->tipo);
    $nestedData[] = $orcamento->aprovado;
    $nestedData[] = $orcamento->documento;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);


//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
