<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");

$data = date("Y-m-d");
$data1 = date("Y-m-d", strtotime("-190 days", strtotime($data)));
//echo $data;


//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

function diferencaDatas($data) {
    $dataInformada = DateTime::createFromFormat('d/m/Y', $data);
    
    if (!$dataInformada) {
        throw new Exception("Formato de data inválido. Use 'd/m/Y'.");
    }

    $dataAtual = new DateTime();
    $diferenca = $dataAtual->diff($dataInformada);

    return $diferenca->days * ($diferenca->invert ? -1 : 1);
}
   
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$requestData = $_REQUEST;
$columns = array(
    0 => 'id',
    1 => 'nNF',
    2 => 'modelo',
    3 => 'serie',
    4 => 'dhEmi',
    5 => 'destxNome',
    6 => 'vNF',
    7 => 'chavenfe',
    8 => 'status',
    9 => 'tpAmb',
    10 => 'dias',
    11 => 'dataMaxRetorno'
);

$sql = "SELECT id, tipo, nNF, modelo, serie, dhEmi, destxNome, vNF, chavenfe, tpAmb, retorno, CFOP from nfe where tipo='Entrada' and empresa = '" . $_SESSION['Empresa'] . "'";
$arrayParam = '';

$sql .= ' AND retorno <> "S"';
$sql .= ' AND ((CFOP ="1901") or (CFOP ="1915"))';
$sql .= ' AND str_to_date(dhEmi, "%d/%m/%Y") BETWEEN "' . $data1 . '" AND "' . $data . '"  ';

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND nNF like '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND modelo = '" . $requestData['columns'][2]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND serie = '" . $requestData['columns'][3]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND dhEmi LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND destxNome LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND vNF LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND chavenfe LIKE '%" . $requestData['columns'][7]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][8]['search']['value'])) {

    $sql .= " AND status LIKE '%" . $requestData['columns'][8]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][9]['search']['value'])) {
    $sql .= " AND tpAmb LIKE '%" . $requestData['columns'][9]['search']['value'] . "%' ";
}
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY " . $columns[$requestData['order'][0]['column']] . " " . $requestData['order'][0]['dir'] . " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

// echo $sql;
$data = array();
foreach ($dados as $nfe) {
    $datahj = date("Y-m-d");
    $data_inicio = new DateTime($datahj);
    $dataemissao = parseDate($nfe->dhEmi, "Y-m-d");
    $data_fim = new DateTime($dataemissao);

    $dataMaxRetorno = date("d/m/Y", strtotime("+180 days", strtotime($dataemissao)));
    
    $diasAteRetorno = diferencaDatas($dataMaxRetorno);

    $dateInterval = $data_inicio->diff($data_fim);
    $dias= $dateInterval->days;
    
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $nfe->id . "'  />";
    $nestedData[] = $nfe->nNF;
    $nestedData[] = $nfe->modelo;
    $nestedData[] = $nfe->serie;
    $nestedData[] = $nfe->dhEmi;
    $nestedData[] = $nfe->destxNome;
    $nestedData[] = "R$ " . $nfe->vNF;
    $total = $total + $nfe->vNF;

    if ($nfe->status == '') :
        $status = 'Pendente';
    elseif ($nfe->status == '100') :
        if ($nfe->cce == 'S') :
            $status = 'Aprovado(CCE)';
        else :
            $status = 'Aprovado';
        endif;
    elseif ($nfe->status == '101') :
        $status = '<i class="fa fa-info-circle" title="' . $nfe->datacancelamento . ' - ' . $nfe->motivocancelamento . '"> </i>';
        $status .= ' Cancelada ';
    endif;

    $nestedData[] = $nfe->chavenfe;

    if ($diasAteRetorno < 0) {
        $nestedData[] = "<label class='label label-danger' style='font-size: 95%;'> $dataMaxRetorno - Vencida! </label>";
    } else if ($diasAteRetorno === 0) {
        $nestedData[] = "<label class='label label-warning' style='font-size: 95%;'> <strong> $dataMaxRetorno - Hoje! </strong> </label>";
    } else if ($diasAteRetorno < 3){
        $nestedData[] =  "<label class='label label-info' style='font-size: 95%;'> $dataMaxRetorno  - $diasAteRetorno dia(s)! </label>";
    } else {
        $nestedData[] = $dataMaxRetorno . " - $diasAteRetorno dia(s)";
    }
    
    $nestedData[] = $ambiente;
    $nestedData[] = $dias;
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, 2, ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
