<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");
require_once("../../../../_backend/_class/status_class.php");

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor WHERE vendedorid = " . $valor . "";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);
 
    return $dados->xNome;
    
}

function Para($valor) {
    if ($valor == 'R') :
        return 'Representante';
    elseif ($valor == 'F') :
        return 'Funcionário';
    else :
        return 'Cliente';
    endif;
}

function Situacao($valor) {
    if ($valor == 'A') :
        return '<label class="label label-warning" style="font-size: 95%;"> Aberta </label>';
    elseif ($valor == 'C') :
        return '<label class="label label-danger" style="font-size: 95%;"> Cancelada </label>';
    elseif ($valor == 'E') :
        return '<label class="label label-info" style="font-size: 95%;"> Em preparo </label>';
    elseif ($valor == 'S') :
        return '<label class="label label-primary" style="font-size: 95%;"> Saiu para entrega </label>';
    else :
        return '<label class="label label-success" style="font-size: 95%;"> Fechada </label>';
    endif;
}

function Tipo($valor) {
    if ($valor == 'S') :
        return 'Direta';
    elseif ($valor == 'R') :
        return 'S.Remessa';
    elseif ($valor == 'O') :
        return 'Orçamento';
    else :
        return 'Consignada';
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_movimentacao',
    1 => 'doc_empresa',
    2 => 'data',
    3 => 'para',
    4 => 'cliente',
    5 => 'valor',
    6 => 'situacao',
    7 => 'tipo',
    8 => 'documento',
    9 => 'controle',
    10 => 'status',
    11 => 'comanda',
    12 => 'conta',
    13 => 'vendedor',
    14 => 'transportador'
);

$sql = "select movimentacao.`documento`, movimentacao.data, movimentacao.hora, movimentacao.controle, movimentacao.para,movimentacao.vendedor, movimentacao.desconto, 
movimentacao.`representante`, movimentacao.cliente, movimentacao.funcionario,movimentacao.troco, movimentacao.motivocancelado, movimentacao.status,
movimentacao.`valorpago`, movimentacao.`valortotal`,  movimentacao.`tipo`, movimentacao.situacao, movimentacao.empresa, movimentacao.doc_empresa,
movimentacao.comanda,movimentacao.conta,
`representante`.`representanteid`, `representante`.`xNome` as xNomeR, representante.`xFant` as xFantR, 
cliente.`clienteid`, cliente.`xNome` as xNomeC, cliente.`xFant` as xFantC, 
funcionario.`funcionarioid`, funcionario.`xNome` as xNomeF, funcionario.`xFant` as xFantF,
transportador.transportadorid, transportador.xNome as transportadornome
From `movimentacao`
LEFT JOIN `representante` ON `representante`.`representanteid` = `movimentacao`.`representante`
LEFT JOIN cliente ON `cliente`.`clienteid` = `movimentacao`.`cliente`
LEFT JOIN transportador on `transportador`.`transportadorid` = `movimentacao`.`transportador` 
LEFT JOIN funcionario on `funcionario`.`funcionarioid` = `movimentacao`.`funcionario` ";
$arrayParam = '';
$sql .= " WHERE 1=1 AND movimentacao.empresa = '" . $_SESSION['Empresa'] . "'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND doc_empresa LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND data LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND para LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $termos = explode(' ', $requestData['columns'][4]['search']['value']); // Divide o texto em palavras
    $condicoes = []; // Array para armazenar as condições
    
    foreach ($termos as $termo) {
        $condicoes[] = "(representante.`xNome` LIKE '%" . $termo . "%' 
                        OR cliente.`xNome` LIKE '%" . $termo . "%' 
                        OR funcionario.`xNome` LIKE '%" . $termo . "%')";
    }

    // Junta as condições com AND para garantir que todas as palavras sejam consideradas
    $sql .= " AND (" . implode(' AND ', $condicoes) . ") ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND valorpago LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND situacao LIKE '%" . $requestData['columns'][6]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][7]['search']['value'])) {
    $sql .= " AND movimentacao.tipo = '" . $requestData['columns'][7]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][9]['search']['value'])) {
    $sql .= " AND movimentacao.tipo = '" . $requestData['columns'][9]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][10]['search']['value'])) {
    $sql .= " AND movimentacao.status = '" . $requestData['columns'][10]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][11]['search']['value'])) {
    $sql .= " AND movimentacao.comanda = '" . $requestData['columns'][11]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][12]['search']['value'])) {
    $sql .= " AND movimentacao.conta = '" . $requestData['columns'][12]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][13]['search']['value'])) {
    $sql .= " AND movimentacao.vendedor = '" . $requestData['columns'][13]['search']['value'] . "' ";
}

if (!empty($requestData['columns'][14]['search']['value'])) {
    $sql .= " AND transportador.transportadorid = '" . $requestData['columns'][14]['search']['value'] . "' ";
}

$dataInicial = isset($requestData['dataInicial']) ? $requestData['dataInicial'] : '';
$dataFinal = isset($requestData['dataFinal']) ? $requestData['dataFinal'] : '';

if (!empty($dataInicial) && !empty($dataFinal)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') BETWEEN str_to_date('$dataInicial', '%d/%m/%Y') AND str_to_date('$dataFinal', '%d/%m/%Y') ";
} elseif (!empty($dataInicial)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') >= str_to_date('$dataInicial', '%d/%m/%Y') ";
} elseif (!empty($dataFinal)) {
    $sql .= " AND str_to_date(data, '%d/%m/%Y') <= str_to_date('$dataFinal', '%d/%m/%Y') ";
}


//echo $sql;
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

// echo '<pre>';
//     print_r($requestData);
// echo '</pre><br>';

if ($requestData['order'][0]['column'] == '5') :
    $sql .= " ORDER BY valorpago ";
    $sql .= $requestData['order'][0]['dir'];

else:
    $sql .= " ORDER BY doc_empresa desc ";
endif;

$sql .= " LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */
$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

// echo $sql;

$total = 0;
$data = array();
foreach ($dados as $movimentacao) {
    $nestedData = array();
    $nestedData[] = "<input type='checkbox' class='DeleteRow' value='" . $movimentacao->documento . "' onclick=' SetSel(this);' />";
    $nestedData[] = $movimentacao->doc_empresa;
    $nestedData[] = "$movimentacao->data $movimentacao->hora";
    $nestedData[] = Para($movimentacao->para);
    if ($movimentacao->situacao == 'C') :
        $nestedData[] = $movimentacao->xNomeR . $movimentacao->xNomeC . $movimentacao->xNomeF . '  <b>(' . $movimentacao->motivocancelado . ') </b>';
    else :
        $nestedData[] = $movimentacao->xNomeR . $movimentacao->xNomeC . $movimentacao->xNomeF;
    endif;
    $total = $total + ($movimentacao->valortotal - $movimentacao->desconto);
    $nestedData[] = 'R$ ' . number_format($movimentacao->valortotal - $movimentacao->desconto, $parametros->casadecimal, ',', '.');
    $nestedData[] = Situacao($movimentacao->situacao);
    $nestedData[] = Tipo($movimentacao->tipo);
//    $nestedData[] = Tipo($movimentacao->tipo);
    $nestedData[] = $movimentacao->documento;
    $nestedData[] = $movimentacao->controle;
    $nestedData[] = $statusvenda[$movimentacao->status];
    $nestedData[] = $movimentacao->comanda;
    $nestedData[] = $movimentacao->conta;
    $nestedData[] = BuscaVendedor($movimentacao->vendedor);
    $nestedData[] = $movimentacao->transportadornome;

    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
    "total" => 'R$ ' . number_format($total, '2', ',', '.')
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
