<?php

//require_once("../../../functions.php");
require_once("../../../_class/Conexao_class.php");
require_once("../../../_class/Crud_class.php");
require_once("../../../../_backend/_class/parametros.php");
require_once("../../../../_backend/_class/status_class.php");

function BuscaVendedor($valor) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'vendedor');
    $sql = "SELECT * from vendedor WHERE vendedorid = " . $valor . "";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->xNome;
}

function Para($valor) {
    if ($valor == 'R') :
        return 'Representante';
    elseif ($valor == 'F') :
        return 'Funcionário';
    else :
        return 'Cliente';
    endif;
}

function Situacao($valor) {
    if ($valor == 'A') :
        return 'Aberta';
    elseif ($valor == 'C') :
        return 'Cancelada';
    else :
        return 'Fechada';
    endif;
}

function Tipo($valor) {
    if ($valor == 'S') :
        return 'Direta';
    elseif ($valor == 'R') :
        return 'S.Remessa';
    elseif ($valor == 'O') :
        return 'Orçamento';
    else :
        return 'Consignada';
    endif;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movimentacao');

// storing  request (ie, get/post) global array to a variable  
$requestData = $_REQUEST;

$columns = array(
// datatable column index  => database column name
//    1 => 'cod_movimentacao',
    1 => 'produto',
    2 => 'descricao',
    3 => 'quantidade',
    4 => 'preco',
    5 => 'desconto',
    6 => 'total'
);

$sql = "SELECT itmovimentacao.documento, itmovimentacao.produto, itmovimentacao.preco, sum(itmovimentacao.desc_rateio) as desconto,
sum(itmovimentacao.valorbruto), sum(itmovimentacao.valorliquido) as total, sum(itmovimentacao.quantidade) as qtd, 
itmovimentacao.cancelado, movimentacao.documento, movimentacao.cliente, movimentacao.empresa,
estoqueprodutos.codproduto, estoqueprodutos.produto, produtos.codigo, produtos.descricao
FROM itmovimentacao
INNER JOIN movimentacao ON movimentacao.documento = itmovimentacao.documento
INNER JOIN estoqueprodutos ON estoqueprodutos.codproduto = itmovimentacao.produto
INNER JOIN produtos ON produtos.codigo = estoqueprodutos.produto
WHERE itmovimentacao.cancelado = 'N' AND movimentacao.cliente = '" . $_GET['cliente'] . "'";
$arrayParam = '';
$sql .= " AND movimentacao.empresa = '" . $_SESSION['Empresa'] . "'";

if (!empty($requestData['columns'][1]['search']['value'])) {
    $sql .= " AND itmovimentacao.produto LIKE '%" . $requestData['columns'][1]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][2]['search']['value'])) {
    $sql .= " AND descricao LIKE '%" . $requestData['columns'][2]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][3]['search']['value'])) {
    $sql .= " AND quantidade LIKE '%" . $requestData['columns'][3]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][4]['search']['value'])) {
    $sql .= " AND preco LIKE '%" . $requestData['columns'][4]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][5]['search']['value'])) {
    $sql .= " AND desconto LIKE '%" . $requestData['columns'][5]['search']['value'] . "%' ";
}

if (!empty($requestData['columns'][6]['search']['value'])) {
    $sql .= " AND total = '" . $requestData['columns'][6]['search']['value'] . "' ";
}

$sql .= " GROUP BY itmovimentacao.produto, itmovimentacao.preco ";

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
$totalData = count($dados);
$totalFiltered = $totalData;

$sql .= " ORDER BY itmovimentacao.documento DESC LIMIT " . $requestData['start'] . " ," . $requestData['length'] . "   ";
/* $requestData['order'][1]['column'] contains column index, $requestData['order'][1]['dir'] contains order such as asc/desc  */

$dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
//echo $sql;

$total = 0;
$data = array();
foreach ($dados as $movimentacao) {
    $nestedData = array();
    $nestedData[] = $movimentacao->codproduto;
    $nestedData[] = $movimentacao->descricao;
    $nestedData[] = number_format($movimentacao->qtd, $parametros->casadecimal, ',', '.');
    $nestedData[] = 'R$ ' . number_format($movimentacao->preco, $parametros->casadecimal, ',', '.');
    $nestedData[] = 'R$ ' . number_format($movimentacao->desconto, $parametros->casadecimal, ',', '.');
    $nestedData[] = 'R$ ' . number_format($movimentacao->total, $parametros->casadecimal, ',', '.');
    $data[] = $nestedData;
}

$json_data = array(
    "draw" => intval($requestData['draw']), // for every request/draw by clientside , they send a number as a parameter, when they recieve a response/data they first check the draw number, so we are sending same number in draw. 
    "recordsTotal" => intval($totalData), // total number of records
    "recordsFiltered" => intval($totalFiltered), // total number of records after searching, if there is no searching then totalFiltered = totalData
    "data" => $data, // total data array
);

//echo '<pre>';
//print_r($json_data);
//echo '</pre>';
echo json_encode($json_data);  // send data as json format
?>
