<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";
require_once "../../_class/parametros.php";
require_once "../../_class/atualiza_estoque.php";
require_once "../../../_fiscal/_ibpt/bootstrap.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

use NFePHP\Ibpt\Ibpt;

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}


function Retornavalor($valor, $retorno, $desc) {
    if ($valor > 0) :
        return ($retorno - $desc);
    else :
        return 0;
    endif;
}

function RetornaImp($p, $b, $desc) {
    if ($p > 0) :
        $b = $b - $desc;
        return $imposto = $b * ($p / 100);
    else :
        return 0;
    endif;
}

function VerificaCST($CNPJ, $IE) {
    $tdCNPJ = strlen($CNPJ);
    if ($IE == '') {
        return '102';
    } elseif ($tdCNPJ > 13) {
        return '101';
    } else {
        return '102';
    }
}

function BuscaPara($valor, $id) {
    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

$doc = $_GET['documento'];
if (strstr($doc, ":")) :
    $doc = explode(':', $doc);
    $empresa = $doc[0];
    $documento = $doc[1];
    $porcentagem = $doc[2];
    $geradoc = 'S';
else :
    $empresa = $_SESSION['Empresa'];
    $documento = $doc;
    $porcentagem = 100;
    $geradoc = 'N';
endif;


$nfeid = $_GET['nfe'];
//DUPLICA O DOCUMENTO
function objectToArray($object) {
    if (!is_object($object) && !is_array($object))
        return $object;
    return array_map('objectToArray', (array) $object);
}


$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao where doc_empresa = '" . $documento . "' and empresa = '$empresa'";
$arrayParam = '';
$movimentacaodoc = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$pdo = Conexao::getInstance();
$crud = Crud:: getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovimentacao where documento = '" . $movimentacaodoc->documento . "' and cancelado = 'N' ORDER BY item ASC";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

foreach ($produtos as $prod) :

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'itmovsai');
    $sql = "SELECT produto, codproduto from estoqueprodutos where codproduto = '$prod->produto'";
    $arrayParam = '';
    $estoqueproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $proddados = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (count($proddados) > 0) :
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud:: getInstance($pdo, 'itmovsai');
        $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '1'";
        $arrayParam = '';
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    echo $sql;

    if ($proddados->tributacaotipo === 'O') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from produtos_icms WHERE produto = '" . $estoqueproduto->produto . "' and uf = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from fiscalicmsinterestadual WHERE origem = '" . $emitente->UF . "' and destino = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
    endif;

//    print_r($produtos_icms);

    if ($emitente->UF != $dest->UF) :
        $cfop = $proddados->cfopuf;
    else :
        $cfop = $proddados->cfop;
    endif;

    if ($produtos_icms->icms > 4) :
        $origem = '0';
    else :
        $origem = '1';
    endif;

    if ($emitente->regimetributario == '1') :
        $CST = VerificaCST($dest->CNPJ, $dest->IE);

    else :
        $CST = $proddados->cst;
    endif;

    if ($_GET['tipoem'] == 'MAn') :
        $cfop = $proddados->cfopmanifesto;
        $CST = '400';
        $origem = '0';
//        echo $cfop;
    endif;

    if ($porcentagem < 100) :
        $vr = $prod->preco * ($porcentagem / 100);

        if ($parametros->arredondamento_prod != '') :
            $vr = intval($vr) . '.' . $parametros->arredondamento_prod;
        endif;

        $prod->preco = $vr;
        $prod->valorbruto = $prod->quantidade * $vr;

    endif;

    $vProdnf = $vProdnf + $prod->valorbruto;
    $totaldesc = $totaldesc + $prod->desconto;
    $totalpecas = $totalpecas + $prod->quantidade;
    $produtonfe = array(
        "cProd" => $prod->produto,
        "NFe" => $nfeid,
        "xProd" => $proddados->descricao,
        "uCom" => $proddados->unidade,
        "vProd" => $prod->preco,
        "NCM" => $proddados->ncm,
        "CST" => $CST,
        "modBC" => $proddados->modBC,
        "qtd" => $prod->quantidade,
        "valortotal" => $prod->valorbruto,
        "orig" => $origem,
        "CFOP" => $cfop,
        "vDesc" => $prod->desconto
    );
//    echo $proddados->pICMS;
    if ($proddados->tributado == 'S') :
        if ($CST == '20') :

            $pRedBC = $proddados->pRedBC;
            if ($pRedBC > 0) :
                $vBCICMS = $vBCICMS + (Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto) * ($pRedBC / 100));
                $vBCICMSProd = Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto) * ($pRedBC / 100);
                $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $vBCICMSProd, $prod->desconto);
            else :
                $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto);
                $vBCICMSProd = Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto);
                $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto);
            endif;

            $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto);
            $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $prod->desconto);

        else :
            $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto);
            $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto);
            $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto);
            $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $prod->desconto);
        endif;
        $prodnfeimp = array(
            "pICMS" => $produtos_icms->icms,
            "vBC" => Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto),
            "vICMS" => RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto),
            "pRedBC" => "0",
            "CSTIPI" => $proddados->cstipi,
            "pIPI" => $proddados->pIPI,
            "vBCIPI" => Retornavalor($proddados->pIPI, $prod->valorbruto, $prod->desconto),
            "vIPI" => RetornaImp($proddados->pIPI, $prod->valorbruto, $prod->desconto),
            "CSTPIS" => $proddados->cstpis,
            "pPIS" => $proddados->pPIS,
            "vBCPIS" => Retornavalor($proddados->pPIS, $prod->valorbruto, $prod->desconto),
            "vPIS" => RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto),
            "CSTCOFINS" => $proddados->cstcofins,
            "pCOFINS" => $proddados->pCOFINS,
            "vBCCOFINS" => Retornavalor($proddados->pCOFINS, $prod->valorbruto, $prod->desconto),
            "vCOFINS" => RetornaImp($proddados->pCOFINS, $prod->valorbruto, $prod->desconto),
        );
    else :
        $vBCICMS = $vBCICMS + 0;
        $vICMS = $vICMS + 0;
        $vPIS = $vPIS + 0;
        $vCOFINS = $vCOFINS + 0;
        $prodnfeimp = array(
            "CSTIPI" => $proddados->cstipi,
            "CSTPIS" => $proddados->cstpis,
            "CSTCOFINS" => $proddados->cstcofins,
        );
    endif;

    if ($emitente->tokenibpt != '') :
        $token = $emitente->tokenibpt;
        $cnpj = $emitente->CNPJ;

        $ncm = $proddados->ncm; //coloque o NCM do produto
        $uf = $emitente->UF; //coloque o estado que deseja saber os dados
        $extarif = 0; //indique o numero da exceção tarifaria, se existir ou deixe como zero
        $codigoInterno = '';
        $descricao = $proddados->descricao;
        $unidadeMedida = $proddados->unidade;
        $valor = $prod->valorbruto;
        $gtin = 'SEM GTIN';
        $ibpt = new Ibpt($cnpj, $token);

        $resp = $ibpt->productTaxes(
                $uf, $ncm, $extarif, $descricao, $unidadeMedida, $valor, $gtin, $codigoInterno
        );

//        $_POST['vTotTrib'] = $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal;
//
//        $_POST['tribFederal'] = $resp->ValorTributoNacional;
//        $_POST['tribEstadual'] = $resp->ValorTributoEstadual;
//        $_POST['tribMunicipal'] = $resp->ValorTributoMunicipal;

        $tribaprox = array(
            "tribFederal" => $resp->ValorTributoNacional,
            "tribEstadual" => $resp->ValorTributoEstadual,
            "tribMunicipal" => $resp->ValorTributoMunicipal,
            "vTotTrib" => $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal
        );
    else :
        $tribaprox = array(
            "tribFederal" => '0',
            "tribEstadual" => '0',
            "tribMunicipal" => '0',
            "vTotTrib" => '0'
        );
    endif;

    $prodnfe = array_merge($produtonfe, $prodnfeimp, $tribaprox);
//    $prodnfe = array_filter($prodnfe);

    $total = count($prodnfe);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = $crud->SQLinsert('produtonfe', $prodnfe, $total);
    $retorno = $crud->Sql($sql);

    $item++;

endforeach;
//echo $sql;

if ($nfeid > 0) :
    $arr = array("status" => 'OK', "mensagem" => 'NF-e Gerada com sucesso! Nº ' . $nfeid . '');
else :
    $arr = array("nfe" => 0, "mensagem" => "Não foi possivél gerar a NF-e");
endif;

echo json_encode($arr);