<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

function BuscaGrupo($sequencia, $nivel) {
    $pdo  = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'grupos');
    $sql  = "SELECT * from grupos WHERE sequencia = '$sequencia' ";
    $arrayParam = [];
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    // Evita erro no PHP 8.1 se não encontrar nada
    if (!$dados) {
        return null;
    }

    if ($nivel == 'S') :
        return $dados->nivel ?? null;
    else :
        return $dados->gruposid ?? null;
    endif;
}

$grupo = $_POST['grupo'] ?? '';

// Busca Grupo
$pdo  = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'grupos');

if ($grupo == '') :
    $sql = "SELECT * from grupos where nivel = 1 ORDER BY gruposid DESC LIMIT 1";
else :
    $gp  = BuscaGrupo($grupo, 'N');
    $sql = "SELECT * from grupos WHERE grupo = '$gp' ORDER BY gruposid DESC LIMIT 1 ";
endif;

$arrayParam = [];
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//echo $sql;

// Definição inicial segura
$sequencia = '';
$nivelcom  = '';

if ($grupo == '') {
    // quando não tem grupo pai
    if ($dados && isset($dados->sequencia) && $dados->sequencia !== '') {
        $sequencia = $dados->sequencia;
    } else {
        $sequencia = '00.00.00';
    }
    $nivelcom = BuscaGrupo($grupo, 'S'); // vai acabar vindo null, mas mantém a lógica original
} else {
    // quando tem grupo pai
    if ($dados && isset($dados->sequencia) && $dados->sequencia !== '') {
        $sequencia = $dados->sequencia;
    } else {
        $sequencia = $grupo;
    }
    $nivelcom = BuscaGrupo($grupo, 'S');
}

// Garante que a sequência tenha ao menos o formato 00.00.00
if (empty($sequencia)) {
    $sequencia = '00.00.00';
}

$sequencia = explode('.', $sequencia);

// Usa valores padrão para evitar undefined offset
$seq0 = $sequencia[0] ?? '00';
$seq1 = $sequencia[1] ?? '00';
$seq2 = $sequencia[2] ?? '00';

if ($grupo != '') :
    $_POST['grupo'] = $gp;

    if ($nivelcom == '1') :
        $nivel = '2';
        $seq1 = (int)$seq1 + 1;
        if ($seq1 < 10) :
            $seq1 = '0' . $seq1;
        endif;
    else :
        $nivel = '3';
        $seq2 = (int)$seq2 + 1;
        if ($seq2 < 10) :
            $seq2 = '0' . $seq2;
        endif;
    endif;
else :
    $nivel = '1';
    $seq0 = (int)$seq0 + 1;
    if ($seq0 < 10) :
        $seq0 = '0' . $seq0;
    endif;
    unset($_POST['grupo']);
endif;

$seq = $seq0 . '.' . $seq1 . '.' . $seq2;

if ($seq == '01..') :
    $seq = '01.00.00';
endif;

$_POST['sequencia'] = $seq;
$_POST['nivel']     = $nivel;

//echo $seq;
// Consumindo métodos do CRUD genérico 
// Atribui uma conexão PDO   
$pdo = Conexao::getInstance();
$pdo->beginTransaction();
// Atribui uma instância da classe Crud, passando como parâmetro a conexão PDO e o nome da tabela  
$crud    = Crud::getInstance($pdo, 'grupos');
$retorno = $crud->insert($_POST);

if (!$retorno) :
    $pdo->rollBack();
    $msg     = 'Houve um Erro ao cadastrar o Grupo de Produto, tente novamente!';
    $retorno = -1;
else :
    $pdo->commit();
    $msg = 'Grupo de Produto Cadastrado com SUCESSO!';
endif;

//print_r($_POST);
$exec = array("mensagem" => $msg, "retorno" => $retorno);
echo json_encode($exec);
