<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";
require_once "../../_class/parametros.php";
require_once "../../../_fiscal/_ibpt/bootstrap.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');
use NFePHP\Ibpt\Ibpt;

$data = date("d/m/Y");
$hora = date("H:i");

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}

function Retornavalor($valor, $retorno, $desc, $uffora) {
    if ($valor > 0) :
        if ($uffora == 'S') :
            return ($retorno);
        else :
            return ($retorno - $desc);
        endif;
    else :
        return 0;
    endif;
}

function RetornaImp($p, $b, $desc, $uffora = 'N') {
    if ($p > 0) :
        if ($uffora == 'S') :
//            $b = $b - $desc;
            $imposto = $b * ($p / 100);
            return $imposto;
        else :
            $b = $b - $desc;
            $imposto = $b * ($p / 100);
            return $imposto;
        endif;

    else :
        return 0;
    endif;
}

function BuscaPara($valor, $id) {
    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

function VerificaCST($CNPJ, $IE) {
    $tdCNPJ = strlen($CNPJ);
    if ($IE == '') {
        return '102';
    } elseif ($tdCNPJ > 13) {
        return '101';
    } else {
        return '102';
    }
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao where documento = " . $_GET['documento'] . "";
$arrayParam = '';
$movimentacao = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//print_r($movimentacao);
//$dataemi = $movimentacao->data;
//if(isset($_GET['ecommerce'])) :
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM pedidos_integracoes where id = " . $_GET['ped_integracao'] . "";
$arrayParam = '';
$pedidoecom = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

$dataemi = $pedidoecom->data_pedido;
//endif;

if ($movimentacao->para == 'R') :
    $id = $movimentacao->representante;
    $dest = BuscaPara('R', $movimentacao->representante);
elseif ($movimentacao->para == 'F') :
    $id = $movimentacao->funcionario;
    $dest = BuscaPara('F', $movimentacao->funcionario);
else :
    $id = $movimentacao->cliente;
    $dest = BuscaPara('C', $movimentacao->cliente);
endif;

$dest = limpar_dados($dest);

$pdo = Conexao::getInstance();
$crud = Crud:: getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovimentacao where documento = '" . $_GET['documento'] . "' and cancelado = 'N' ORDER BY item ASC";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//echo $sql;
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pagmovsai');
$sql = "SELECT * FROM recebimentomov where documento = " . $_GET['documento'] . "";
$arrayParam = '';
$pagmovsaida = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

if (count($pagmovsaida) > 1) :
    $indpag = 1;
else :
    $indpag = 0;
endif;

if ($_GET['modelo'] == '55') :
    $serie = $emitente->seriepadrao;
else :
    $serie = $emitente->seriepadraonfce;
endif;

if ($_GET['modelo'] == '01') :
    $nNF = $_GET['controle'];
    $status = '999';
else :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'nfe');
    $sql = "SELECT nNF FROM nfe where empresa = '" . $_SESSION['Empresa'] . "' and 
        modelo = '" . $_GET['modelo'] . "' and  serie = '" . $serie . "' 
        and tipo = 'Saida' ORDER BY nNF Desc LIMIT 1";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
    $nNF = $dados->nNF + 1;
    $status = '';

//    echo $sql;
endif;

$modfrete = '1';

$nfe = array(
    "natOp" => 'Venda',
    "modelo" => $_GET['modelo'],
    "serie" => $serie,
    "nNF" => $nNF,
    "dhEmi" => $dataemi,
    "hEmi" => $hora,
    "dhSaiEnt" => $dataemi,
    "hSaiEnt" => $hora,
    "tpEmis" => '1',
    "finNFe" => '1',
    "indPres" => '2',
    "indIntermed" => '0',
    "tpNF" => '1',
    "modFrete" => $modfrete,
    "empresa" => $_SESSION['Empresa'],
    "emitente" => $_SESSION['Empresa'],
    "tipo" => 'Saida',
    "status" => $status,
    "documento" => $_GET['documento'],
    "tipodoc" => "SA",
    "indPag" => $indpag
);

//print_r($nfe);
//

if (trim($dest->UF) === '') :
    $dest->UF = $emitente->UF;
endif;

$cliente = array(
    "destCNPJ" => $dest->CNPJ,
    "destIE" => $dest->IE,
    "destxNome" => $dest->xNome,
    "destCEP" => $dest->CEP,
    "destxLgr" => $dest->xLgr,
    "destxCpl" => $dest->xCpl,
    "destnro" => $dest->nro,
    "destxBairro" => $dest->xBairro,
    "destxMun" => $dest->xMun,
    "destcMun" => $dest->cMun,
    "destUF" => $dest->UF,
    "destfone" => $dest->fone,
    "destemail" => $dest->email
);

$total = array(
    "vBCSTnf" => '0',
    "vSTnf" => '0',
    "vProdnf" => $movimentacao->valortotal + $movimentacao->desconto - $movimentacao->frete,
    "vFretenf" => $movimentacao->frete,
    "vSegnf" => '0',
    "vDescnf" => $movimentacao->desconto,
    "vIInf" => '0',
    "vIPInf" => '0',
    "vPISnf" => '0',
    "vCOFINSnf" => '0',
    "vOutronf" => '0',
    "vNF" => number_format($movimentacao->valortotal, 2, '.', '')
);

//print_r($total);

if ($movimentacao->transportador == '') :
    $transpxNome = '';
else :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'movsai');
    $sql = "SELECT * FROM transportador where transportadorid = '" . $movimentacao->transportador . "'";
    $arrayParam = '';
    $transp = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
    $transpxNome = $transp->xNome;
endif;

$transportadora = array(
    "transpxNome" => $transpxNome
);

$insnfe = array_merge($nfe, $cliente, $total, $transportadora);
$filternfe = array_filter($insnfe);

$total = count($filternfe);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = $crud->SQLinsert('nfe', $filternfe, $total);
$retorno = $crud->SqlID($sql);
//echo $sql;
$nfeid = $retorno;

$sql = "update nfe set indPag = '$indpag' where id = '$nfeid'";
$retorno = $crud->Sql($sql);

$valorTotalProdutos = 0;
foreach ($produtos as $produto) {
    $valorTotalProdutos += $produto->valorbruto;
}

$descTotal = $movimentacao->desconto;
$descRestante = $descTotal;

$porcentagemProdTotal = [];

foreach ($produtos as $key => $prod) :
    $porcentagemProdTotal[$key] = $prod->valorbruto / $valorTotalProdutos;

    if ($descTotal > 0 && $descRestante > 0) {
        $vDesc = min(number_format(($descTotal * $porcentagemProdTotal[$key]), 2, '.', ''), $descRestante);
        $descRestante -= $vDesc;
    } else {
        $vDesc = 0;
    }

    $prod->desconto = $vDesc;

endforeach;

if ($descRestante > 0) {
    $maiorValor = $produtos[0]->valorbruto;
    $posicaoMaior = 0;
    foreach ($produtos as $key => $prod) {
        if ($prod->valorbruto > $maiorValor) {
            $maiorValor = $prod->valorbruto;
            $posicaoMaior = $key;
        }
    }
    $produtos[$posicaoMaior]->desconto += number_format($descRestante, 2, '.', '');
}

foreach ($produtos as $prod) :

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'itmovsai');
    $sql = "SELECT produto, codproduto from estoqueprodutos where codproduto = '$prod->produto'";
    $arrayParam = '';
    $estoqueproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $proddados = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (count($proddados) > 0) :
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud:: getInstance($pdo, 'itmovsai');
        $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '1'";
        $arrayParam = '';
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    echo $sql;

    if ($proddados->tributacaotipo === 'O') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from produtos_icms WHERE produto = '" . $estoqueproduto->produto . "' and uf = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from fiscalicmsinterestadual WHERE origem = '" . $emitente->UF . "' and destino = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
    endif;

//    print_r($produtos_icms);

    if ($emitente->UF !== $dest->UF) :
        $cfop = $proddados->cfopuf;
        $uffora = 'S';
    else :
        $cfop = $proddados->cfop;
        $uffora = 'N';
    endif;

    if ($produtos_icms->icms > 4) :
        $origem = '0';
    else :
        $origem = '1';
    endif;

    if ($emitente->regimetributario == '1') :
        if ($cfop == '5405') :
            $CST = $proddados->cst;
            $cest = $proddados->cest;
        else :
            $CST = VerificaCST($dest->CNPJ, $dest->IE);
            $cest = $proddados->cest;
        endif;
    else :
        $CST = $proddados->cst;
        $cest = $proddados->cest;

    endif;

//    $descitem = $descitem + $prod->desconto;
//    $descnf = $descnf + $prod->desconto;
    $totalprodv = $totalprodv + $prod->valorbruto;
    $produtonfe = array(
        "cProd" => $prod->produto,
        "NFe" => $nfeid,
        "xProd" => $proddados->descricao,
        "uCom" => $proddados->unidade,
        "vProd" => $prod->preco,
        "NCM" => $proddados->ncm,
        "descANP" => $proddados->descANP,
        "cProdANP" => $proddados->cProdANP,
        "CST" => $CST,
        "modBC" => $proddados->modBC,
        "qtd" => $prod->quantidade,
        "valortotal" => $prod->valorbruto,
        "orig" => $origem,
        "CFOP" => $cfop,
        "vDesc" => $prod->desconto,
        "CEST" => $cest
    );

//    echo '<pre>';
//    print_r($produtonfe);
//    echo '</pre>';
//    echo $proddados->pICMS;
    if ($proddados->tributado == 'S') :
        $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto, $uffora);
        $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto, $uffora);
        $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto);
        $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $prod->desconto);
        $prodnfeimp = array(
            "pICMS" => $produtos_icms->icms,
            "vBC" => Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto, $uffora),
            "vICMS" => RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto, $uffora),
            "pRedBC" => "0",
            "CSTIPI" => $proddados->cstipi,
            "pIPI" => $proddados->pIPI,
            "vBCIPI" => Retornavalor($proddados->pIPI, $prod->valorbruto, $prod->desconto, $uffora),
            "vIPI" => RetornaImp($proddados->pIPI, $prod->valorbruto, $prod->desconto, $uffora),
            "CSTPIS" => $proddados->cstpis,
            "pPIS" => $proddados->pPIS,
            "vBCPIS" => Retornavalor($proddados->pPIS, $prod->valorbruto, $prod->desconto, $uffora),
            "vPIS" => RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto, $uffora),
            "CSTCOFINS" => $proddados->cstcofins,
            "pCOFINS" => $proddados->pCOFINS,
            "vBCCOFINS" => Retornavalor($proddados->pCOFINS, $prod->valorbruto, $prod->desconto, $uffora),
            "vCOFINS" => RetornaImp($proddados->pCOFINS, $prod->valorbruto, $prod->desconto, $uffora),
        );
    else :
        $vBCICMS = $vBCICMS + 0;
        $vICMS = $vICMS + 0;
        $vPIS = $vPIS + 0;
        $vCOFINS = $vCOFINS + 0;
        $prodnfeimp = array(
            "CSTIPI" => $proddados->cstipi,
            "CSTPIS" => $proddados->cstpis,
            "CSTCOFINS" => $proddados->cstcofins,
        );
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * from ibtp WHERE codigo = '$proddados->ncm'";
    $arrayParam = '';
    $ibpt = $crud->getSQLGeneric($sql, $arrayParam, false);

    $tribfederal = $prod->valorbruto * ($ibpt->nacionalfederal / 100);
    $tribEstadual = $prod->valorbruto * ($ibpt->estadual / 100);
    $tribMunicipal = $prod->valorbruto * ($ibpt->municipal / 100);
    $tribImportado = 0; //$prod->valorbruto * ($ibpt->importadosfederal / 100);
    $totaltrib = $tribfederal + $tribEstadual + $tribMunicipal;
    $vTotTribnf = $vTotTribnf + $totaltrib;
    $tribaprox = array(
        "tribFederal" => $tribfederal,
        "tribEstadual" => $tribEstadual,
        "tribMunicipal" => $tribMunicipal,
        "tribImportado" => '0',
        "vTotTrib" => $tribfederal + $tribEstadual + $tribMunicipal
    );

//    if ($emitente->tokenibpt != '') :
//        $token = $emitente->tokenibpt;
//        $cnpj = $emitente->CNPJ;
//
//        $ncm = $proddados->ncm; //coloque o NCM do produto
//        $uf = $emitente->UF; //coloque o estado que deseja saber os dados
//        $extarif = 0; //indique o numero da exceÃ§Ã£o tarifaria, se existir ou deixe como zero
//        $codigoInterno = '';
//        $descricao = $proddados->descricao;
//        $unidadeMedida = $proddados->unidade;
//        $valor = $prod->valorbruto;
//        $gtin = 'SEM GTIN';
//        $ibpt = new Ibpt($cnpj, $token);
//
//        $resp = $ibpt->productTaxes(
//                $uf, $ncm, $extarif, $descricao, $unidadeMedida, $valor, $gtin, $codigoInterno
//        );
//
////        $_POST['vTotTrib'] = $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal;
////
////        $_POST['tribFederal'] = $resp->ValorTributoNacional;
////        $_POST['tribEstadual'] = $resp->ValorTributoEstadual;
////        $_POST['tribMunicipal'] = $resp->ValorTributoMunicipal;
//
//        $tribaprox = array(
//            "tribFederal" => $resp->ValorTributoNacional,
//            "tribEstadual" => $resp->ValorTributoEstadual,
//            "tribMunicipal" => $resp->ValorTributoMunicipal,
//            "vTotTrib" => $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal
//        );
//    else :
//        $tribaprox = array(
//            "tribFederal" => '0',
//            "tribEstadual" => '0',
//            "tribMunicipal" => '0',
//            "vTotTrib" => '0'
//        );
//    endif;

    $prodnfe = array_merge($produtonfe, $prodnfeimp, $tribaprox);
//    $prodnfe = array_filter($prodnfe);

    $total = count($prodnfe);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = $crud->SQLinsert('produtonfe', $prodnfe, $total);
    $retorno = $crud->Sql($sql);

//    echo $sql;
//    echo '<pre>';
//    print_r($prodnfe);
//    echo '</pre>';
    $item++;
endforeach;

$item = 1;
foreach ($pagmovsaida as $dup) :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = "INSERT INTO duplicatanfe(parcela, vencimento, valor, duplicata, nfe, forma) VALUES 
            ('$item', '$dup->dataven', '$dup->valor', '$nNF', '$nfeid', '$dup->tiporeceb')   
            ";
    $retorno = $crud->Sql($sql);
    $item++;
endforeach;

$vnf = $totalprodv + - $movimentacao->desconto;

//echo $totalprod;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update nfe set indPres = '1', vDescnf = vDescnf + $descitem, vNF = $vnf, vTotTribnf = '$vTotTribnf',
    vBCnf = '$vBCICMS', vICMSnf = '$vICMS', vPISnf = '$vPIS', vCOFINSnf = '$vCOFINS' where id = '$nfeid' ";
$retorno = $crud->Sql($sql);

//echo $sql;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update movimentacao set DocFiscal = '$nfeid' where documento = '" . $_GET['documento'] . "' ";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update lancamento set titulo = '$nNF', NotaFiscal = '$nfeid' where documento = '" . $_GET['documento'] . "'";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'itmovimentacao');
$sql = "UPDATE pedidos_integracoes set status = 'NF-e',  nfe = '$nfeid', nNF = '$nNF', empresa_nfe = '" . $_SESSION['Empresa'] . "'
    where id = '" . $pedidoecom->id . "'";
$retorno = $crud->Sql($sql);

//echo $sql;

if ($nfeid > 0) :
    $arr = array("nfe" => $nNF, "id" => $nfeid, "mensagem" => 'NF-e Gerada com sucesso! Nº ' . $nNF . '');
else :
    $arr = array("nfe" => 0, "mensagem" => "NÃ£o foi possivÃ©l gerar a NF-e");
endif;

echo json_encode($arr);
