<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";
require_once "../../_class/parametros.php";
require_once "../../../_fiscal/_ibpt/bootstrap.php";

use NFePHP\Ibpt\Ibpt;

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}

function Retornavalor($valor, $retorno, $desc) {
    if ($valor > 0) :
        return ($retorno - $desc);
    else :
        return 0;
    endif;
}

function RetornaImp($p, $b, $desc) {
    if ($p > 0) :
        $b = $b - $desc;
        return $imposto = $b * ($p / 100);
    else :
        return 0;
    endif;
}

function VerificaCST($CNPJ, $IE) {
    $tdCNPJ = strlen($CNPJ);
    if ($IE == '') {
        return '102';
    } elseif ($tdCNPJ > 13) {
        return '101';
    } else {
        return '102';
    }
}

function BuscaPara($valor, $id) {
    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

$doc = $_GET['documento'];
if (strstr($doc, ":")) :
    $doc = explode(':', $doc);
    $empresa = $doc[0];
    $documento = $doc[1];
    $porcentagem = $doc[2];
else :
    $empresa = $_SESSION['Empresa'];
    $documento = $doc;
    $porcentagem = 100;
endif;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao_dev where doc_empresa = '" . $documento . "' and empresa = '" . $empresa . "'";
$arrayParam = '';
$movimentacao_dev = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//echo $sql;
if ($movimentacao_dev->para == 'R') :
    $id = $movimentacao_dev->representante;
    $dest = BuscaPara('R', $movimentacao_dev->representante);
elseif ($movimentacao_dev->para == 'F') :
    $id = $movimentacao_dev->funcionario;
    $dest = BuscaPara('F', $movimentacao_dev->funcionario);
else :
    $id = $movimentacao_dev->cliente;
    $dest = BuscaPara('C', $movimentacao_dev->cliente);
endif;

$dest = limpar_dados($dest);

$pdo = Conexao::getInstance();
$crud = Crud:: getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovimentacao_dev where documento = '" . $movimentacao_dev->documento . "' and cancelado = 'N' ORDER BY item ASC";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT nNF FROM nfe where empresa = '" . $_SESSION['Empresa'] . "' and modelo = '55' and tipo = 'Saida' ORDER BY nNF Desc LIMIT 1";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
$nNF = $dados->nNF + 1;

$data = date("d/m/Y");
$hora = date("H;i");

if ($_GET['tipoem'] == 'NFe') :
    $natOp = 'Devolução';
else :
    $natOp = 'Devolução';
endif;

$nfe = array(
    "natOp" => $natOp,
    "indPag" => '2',
    "modelo" => '55',
    "serie" => '1',
    "nNF" => $nNF,
    "dhEmi" => $data,
    "hEmi" => $hora,
    "dhSaiEnt" => $data,
    "hSaiEnt" => $hora,
    "indPag" => '2',
    "tpEmis" => '1',
    "finNFe" => '4',
    "indPres" => '1',
    "tpNF" => '1',
    "modFrete" => '9',
    "empresa" => $_SESSION['Empresa'],
    "emitente" => $_SESSION['Empresa'],
    "tipo" => 'Saida',
    "usuario" => $_SESSION['UsuarioID']
);

//

$cliente = array(
    "destCNPJ" => $dest->CNPJ,
    "destIE" => $dest->IE,
    "destxNome" => $dest->xNome,
    "destCEP" => $dest->CEP,
    "destxLgr" => $dest->xLgr,
    "destnro" => $dest->nro,
    "destxBairro" => $dest->xBairro,
    "destxMun" => $dest->xMun,
    "destcMun" => $dest->cMun,
    "destUF" => $dest->UF,
    "destfone" => $dest->fone
);
$tranportadora = array();

$total = array(
    "vBCSTnf" => '0',
    "vSTnf" => '0',
    "vProdnf" => $movimentacao_dev->valortotal,
    "vFretenf" => '0',
    "vSegnf" => '0',
    "vDescnf" => $movimentacao_dev->desconto,
    "vIInf" => '0',
    "vIPInf" => '0',
    "vPISnf" => '0',
    "vCOFINSnf" => '0',
    "vOutronf" => '0',
    "vNF" => number_format($movimentacao_dev->valortotal - $movimentacao_dev->desconto, 2, '.', '')
);

$insnfe = array_merge($nfe, $cliente, $tranportadora, $total);
$filternfe = array_filter($insnfe);

$total = count($filternfe);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = $crud->SQLinsert('nfe', $filternfe, $total);
$retorno = $crud->SqlID($sql);
//echo $sql;
$nfeid = $retorno;

$totalprod = count($produtos);
$totalitemdesc = count($produtos);

if ($movimentacao_dev->desconto > '0') :
    $proddesc = $movimentacao_dev->desconto / $totalprod;
endif;
$vDesc = 0;
$tdesconto = 0;
$item = 1;
$vProdnf = 0;
$totaldesc = 0;
$totalpecas = 0;
foreach ($produtos as $prod) :

    if (isset($proddesc)) :
        if ($item == $totalitemdesc) :
            if ($tdesconto > 0) :
                $vDesca = $movimentacao_dev->desconto - $tdesconto;
                $vDesc = number_format($vDesca, 2, '.', '');
            else :
                $vDesc = $movimentacao_dev->desconto;
            endif;
        else :
            $vDesc = number_format($proddesc, 2, '.', '');
            $tdesconto = $tdesconto + $vDesc;
        endif;
    else :
        $vDesc = 0;
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'itmovsai');
    $sql = "SELECT produto, codproduto from estoqueprodutos where codproduto = '$prod->produto'";
    $arrayParam = '';
    $estoqueproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $proddados = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (count($proddados) > 0) :
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud:: getInstance($pdo, 'itmovsai');
        $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '1'";
        $arrayParam = '';
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    echo $sql;

    if ($proddados->tributacaotipo === 'O') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from produtos_icms WHERE produto = '" . $estoqueproduto->produto . "' and uf = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from fiscalicmsinterestadual WHERE origem = '" . $emitente->UF . "' and destino = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    print_r($produtos_icms);

    if ($emitente->UF != $dest->UF) :
        $cfop = $emitente->cfopdevolucaouf;
    else :
        $cfop = $emitente->cfopdevolucao;
    endif;

    if ($produtos_icms->icms > 4) :
        $origem = '0';
    else :
        $origem = '1';
    endif;

    if ($emitente->regimetributario == '1') :
        $CST = VerificaCST($dest->CNPJ, $dest->IE);
    else :
        $CST = $proddados->cst;
    endif;

    if ($_GET['tipoem'] == 'MAn') :
        $cfop = $proddados->cfopmanifesto;
        $CST = '400';
        $origem = '0';
//        echo $cfop;
    endif;

    if ($porcentagem < 100) :
        $vr = $prod->preco * ($porcentagem / 100);

        if ($parametros->arredondamento_prod != '') :
            $vr = intval($vr) . '.' . $parametros->arredondamento_prod;
        endif;

        $prod->preco = $vr;
        $prod->valorbruto = $prod->quantidade * $vr;

    endif;

    $vProdnf = $vProdnf + $prod->valorbruto;
    $totaldesc = $totaldesc + $vDesc;
    $totalpecas = $totalpecas + $prod->quantidade;
    $produtonfe = array(
        "cProd" => $prod->produto,
        "NFe" => $nfeid,
        "xProd" => $proddados->descricao,
        "uCom" => $proddados->unidade,
        "vProd" => $prod->preco,
        "NCM" => $proddados->ncm,
        "CST" => $CST,
        "modBC" => $proddados->modBC,
        "qtd" => $prod->quantidade,
        "valortotal" => $prod->valorbruto,
        "orig" => $origem,
        "CFOP" => $cfop,
        "vDesc" => $vDesc
    );
//    echo $proddados->pICMS;
    if ($proddados->tributado == 'S') :
        $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc);
        $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc);
        $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc);
        $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc);
        $prodnfeimp = array(
            "pICMS" => $produtos_icms->icms,
            "vBC" => Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc),
            "vICMS" => RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc),
            "pRedBC" => "0",
            "CSTIPI" => $proddados->cstipi,
            "pIPI" => $proddados->pIPI,
            "vBCIPI" => Retornavalor($proddados->pIPI, $prod->valorbruto, $vDesc),
            "vIPI" => RetornaImp($proddados->pIPI, $prod->valorbruto, $vDesc),
            "CSTPIS" => $proddados->cstpis,
            "pPIS" => $proddados->pPIS,
            "vBCPIS" => Retornavalor($proddados->pPIS, $prod->valorbruto, $vDesc),
            "vPIS" => RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc),
            "CSTCOFINS" => $proddados->cstcofins,
            "pCOFINS" => $proddados->vCOFINS,
            "vBCCOFINS" => Retornavalor($proddados->vCOFINS, $prod->valorbruto, $vDesc),
            "vCOFINS" => RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc),
        );
    else :
        $vBCICMS = $vBCICMS + 0;
        $vICMS = $vICMS + 0;
        $vPIS = $vPIS + 0;
        $vCOFINS = $vCOFINS + 0;
        $prodnfeimp = array(
            "CSTIPI" => $proddados->cstipi,
            "CSTPIS" => $proddados->cstpis,
            "CSTCOFINS" => $proddados->cstcofins,
        );
    endif;

    if ($emitente->tokenibpt != '') :
        $token = $emitente->tokenibpt;
        $cnpj = $emitente->CNPJ;

        $ncm = $proddados->ncm; //coloque o NCM do produto
        $uf = $emitente->UF; //coloque o estado que deseja saber os dados
        $extarif = 0; //indique o numero da exceção tarifaria, se existir ou deixe como zero
        $codigoInterno = '';
        $descricao = $proddados->descricao;
        $unidadeMedida = $proddados->unidade;
        $valor = $prod->valorbruto;
        $gtin = 'SEM GTIN';
        $ibpt = new Ibpt($cnpj, $token);

        $resp = $ibpt->productTaxes(
                $uf, $ncm, $extarif, $descricao, $unidadeMedida, $valor, $gtin, $codigoInterno
        );

//        $_POST['vTotTrib'] = $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal;
//
//        $_POST['tribFederal'] = $resp->ValorTributoNacional;
//        $_POST['tribEstadual'] = $resp->ValorTributoEstadual;
//        $_POST['tribMunicipal'] = $resp->ValorTributoMunicipal;

        $tribaprox = array(
            "tribFederal" => $resp->ValorTributoNacional,
            "tribEstadual" => $resp->ValorTributoEstadual,
            "tribMunicipal" => $resp->ValorTributoMunicipal,
            "vTotTrib" => $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal
        );
    else :
        $tribaprox = array(
            "tribFederal" => '0',
            "tribEstadual" => '0',
            "tribMunicipal" => '0',
            "vTotTrib" => '0'
        );
    endif;

    $prodnfe = array_merge($produtonfe, $prodnfeimp, $tribaprox);
//    $prodnfe = array_filter($prodnfe);

    $total = count($prodnfe);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = $crud->SQLinsert('produtonfe', $prodnfe, $total);
    $retorno = $crud->Sql($sql);

    $item++;

endforeach;

$vNF = $vProdnf - $totaldesc;
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update nfe set vBCnf = '$vBCICMS', vICMSnf = '$vICMS', vPISnf = '$vPIS', vCOFINSnf = '$vCOFINS',
    vProdnf = '$vProdnf', vNF = '$vNF' ";

if ($_GET['tipoem'] == 'MAn') :
    $sql .= " , qVol = '$totalpecas'";
endif;

$sql .= " where id = '$nfeid' ";
$retorno = $crud->Sql($sql);

//echo $sql;

if ($nfeid > 0) :
    $arr = array("nfe" => $nNF, "mensagem" => 'NF-e Gerada com sucesso! Nº ' . $nNF . '');
else :
    $arr = array("nfe" => 0, "mensagem" => "Não foi possivél gerar a NF-e");
endif;

echo json_encode($arr);
