<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/Emitente_class.php";
require_once "../../_class/parametros.php";
require_once "../../_class/atualiza_estoque.php";
require_once "../../../_fiscal/_ibpt/bootstrap.php";

//error_reporting(E_ALL);
//ini_set('display_errors', 'On');

use NFePHP\Ibpt\Ibpt;

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}

function Retornavalor($valor, $retorno, $desc) {
    if ($valor > 0) :
        return ($retorno - $desc);
    else :
        return 0;
    endif;
}

function RetornaImp($p, $b, $desc) {
    if ($p > 0) :
        $b = $b - $desc;
        return $imposto = $b * ($p / 100);
    else :
        return 0;
    endif;
}

function VerificaCST($CNPJ, $IE) {
    $tdCNPJ = strlen($CNPJ);
    if ($IE == '') {
        return '102';
    } elseif ($tdCNPJ > 13) {
        return '101';
    } else {
        return '102';
    }
}

function BuscaPara($valor, $id) {
    if ($valor == 'R') :
        $sql = "SELECT * from representante where representanteid = '$id' ";
    elseif ($valor == 'F') :
        $sql = "SELECT * from funcionario where funcionarioid = '$id' ";
    else :
        $sql = "SELECT * from cliente where clienteid = '$id' ";
    endif;

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'tabela');
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

    return $dados;
}

$doc = $_GET['documento'];
if (strstr($doc, ":")) :
    $doc = explode(':', $doc);
    $empresa = $doc[0];
    $documento = $doc[1];
    $porcentagem = $doc[2];
    $geradoc = 'S';
else :
    $empresa = $_SESSION['Empresa'];
    $documento = $doc;
    $porcentagem = 100;
    $geradoc = 'N';
endif;

//DUPLICA O DOCUMENTO
function objectToArray($object) {
    if (!is_object($object) && !is_array($object))
        return $object;
    return array_map('objectToArray', (array) $object);
}

function BuscaUltimoDoc($empresa) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'nfe');
    $sql = "SELECT doc_empresa,documento FROM movimentacao WHERE empresa = '" . $empresa . "' ORDER BY doc_empresa Desc LIMIT 1";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
    $DOCUMENTO = $dados->doc_empresa + 1;

    return $DOCUMENTO;
}

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao where doc_empresa = '" . $documento . "' and empresa = '$empresa'";
$arrayParam = '';
$movimentacaodoc = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//echo $sql;
$docant = $movimentacaodoc->documento;
if ($geradoc === 'S') :
unset($movimentacaodoc->documento);
//unset($movimentacaodoc->cliente);
unset($movimentacaodoc->empresa);

$movimentacaodoc->doc_empresa = BuscaUltimoDoc($_SESSION['Empresa']);
$movimentacaodoc->empresa = $_SESSION['Empresa'];

$movimentacaodoc1 = objectToArray($movimentacaodoc);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, $tabela);
$total = count($movimentacaodoc1);
$sql = $crud->SQLinsert('movimentacao', $movimentacaodoc1, $total);
$documentomov = $crud->SqlID($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT * from itmovimentacao WHERE documento = '" . $docant . "' and cancelado = 'N'";
$arrayParam = '';
$itmovimentacao = $crud->getSQLGeneric($sql, $arrayParam, true);

foreach ($itmovimentacao as $itmovimentacao) :
    unset($itmovimentacao->id);
    $itmovimentacao->documento = $documentomov;
    $itmovimentacao1 = objectToArray($itmovimentacao);

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, $ittabela);
    $total = count($itmovimentacao1);
    $sql = $crud->SQLinsert('itmovimentacao', $itmovimentacao1, $total);
    $retornoit = $crud->Sql($sql);

//    echo $sql;
    if ($retornoit) :
        AtualizaEstoque('S', $itmovimentacao->produto, $itmovimentacao->quantidade, $_SESSION['Estoque'], $_SESSION['Estoque']);
    endif;

endforeach;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT * from recebimentomov WHERE documento = '" . $docant . "'";
$arrayParam = '';
$recebimentomov = $crud->getSQLGeneric($sql, $arrayParam, true);

foreach ($recebimentomov as $recebimentomov) :
    unset($recebimentomov->id);
    unset($recebimentomov->documento);
    $recebimentomov->documento = $documentomov;
    $recebimentomov1 = objectToArray($recebimentomov);

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, $ittabela);
    $total = count($recebimentomov1);
    $sql = $crud->SQLinsert('recebimentomov', $recebimentomov1, $total);
    $retornoreceb = $crud->Sql($sql);

endforeach;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT * from lancamento WHERE documento = '" . $docant . "'";
$arrayParam = '';
$lancamento = $crud->getSQLGeneric($sql, $arrayParam, true);

foreach ($lancamento as $lancamento) :
    unset($lancamento->lancamentoid);
    unset($lancamento->empresa);
    unset($lancamento->documento);
    unset($lancamento->valorpago);
    unset($lancamento->situacao);

    $lancamento->empresa = $_SESSION['Empresa'];
    $lancamento->documento = $documentomov;
    $lancamento->valorpago = 0;
    $lancamento->situacao = 'A';

    $lancamento1 = objectToArray($lancamento);

    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, $ittabela);
    $total = count($lancamento1);
    $sql = $crud->SQLinsert('lancamento', $lancamento1, $total);
    $retornoreceb = $crud->Sql($sql);

endforeach;
else :
    $documentomov = $docant;
endif;

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'movsai');
$sql = "SELECT * FROM movimentacao where documento = '" . $documentomov . "'";
$arrayParam = '';
$movimentacao = $crud->getSQLGeneric($sql, $arrayParam, FALSE);

//echo $sql;
if ($movimentacao->para == 'R') :
    $id = $movimentacao->representante;
    $dest = BuscaPara('R', $movimentacao->representante);
elseif ($movimentacao->para == 'F') :
    $id = $movimentacao->funcionario;
    $dest = BuscaPara('F', $movimentacao->funcionario);
else :
    $id = $movimentacao->cliente;
    $dest = BuscaPara('C', $movimentacao->cliente);
endif;

$dest = limpar_dados($dest);

$pdo = Conexao::getInstance();
$crud = Crud:: getInstance($pdo, 'itmovsai');
$sql = "SELECT * FROM itmovimentacao where documento = '" . $movimentacao->documento . "' and cancelado = 'N' ORDER BY item ASC";
$arrayParam = '';
$produtos = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//echo $sql;
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'pagmovsai');
$sql = "SELECT * FROM recebimentomov where documento = " . $movimentacao->documento . "";
$arrayParam = '';
$pagmovsaida = $crud->getSQLGeneric($sql, $arrayParam, TRUE);

//print_r($pagmovsaida);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = "SELECT nNF FROM nfe where empresa = '" . $_SESSION['Empresa'] . "' and modelo = '55' and tipo = 'Saida' ORDER BY nNF Desc LIMIT 1";
$arrayParam = '';
$dados = $crud->getSQLGeneric($sql, $arrayParam, FALSE);
$nNF = $dados->nNF + 1;

$data = date("d/m/Y");
$hora = date("H:i");

if ($_GET['tipoem'] == 'NFe') :
    $natOp = 'Venda';
else :
    $natOp = 'Remessa p/ venda fora do estabelecimento';
endif;

if (count($pagmovsaida) > 1) :
    $indpag = 1;
else :
    $indpag = 0;
endif;

if ($emitente->seriepadrao > 0) :
    $serie = $emitente->seriepadrao;
else :
    $serie = 1;
endif;

$nfe = array(
    "natOp" => $natOp,
    "modelo" => '55',
    "serie" => '1',
    "nNF" => $nNF,
    "dhEmi" => $data,
    "hEmi" => $hora,
    "dhSaiEnt" => $data,
    "hSaiEnt" => $hora,
    "tpEmis" => '1',
    "finNFe" => '1',
    "indPres" => '1',
    "tpNF" => '1',
    "modFrete" => '9',
    "empresa" => $_SESSION['Empresa'],
    "emitente" => $_SESSION['Empresa'],
    "tipo" => 'Saida',
    "tipodoc" => "SA",
    "documento" => $documentomov,
    "indPag" => $indpag,
    "usuario" => $_SESSION['UsuarioID']
);

//

if ($_GET['tipoem'] == 'NFe') :

    $cliente = array(
        "destCNPJ" => $dest->CNPJ,
        "destIE" => $dest->IE,
        "destxNome" => $dest->xNome,
        "destCEP" => $dest->CEP,
        "destxLgr" => $dest->xLgr,
        "destnro" => $dest->nro,
        "destxBairro" => $dest->xBairro,
        "destxMun" => $dest->xMun,
        "destcMun" => $dest->cMun,
        "destUF" => $dest->UF,
        "destfone" => $dest->fone,
        "destemail" => $dest->email
    );
    $tranportadora = array();
else :

    $cliente = array(
        "destCNPJ" => $emitente->CNPJ,
        "destIE" => $emitente->IE,
        "destxNome" => $emitente->xNome,
        "destCEP" => $emitente->CEP,
        "destxLgr" => $emitente->xLgr,
        "destnro" => $emitente->nro,
        "destxBairro" => $emitente->xBairro,
        "destxMun" => $emitente->xMun,
        "destcMun" => $emitente->cMun,
        "destUF" => $emitente->UF,
        "destfone" => $emitente->fone,
        "destemail" => $dest->email
    );

    $tranportadora = array(
        "transpCNPJ" => $dest->CNPJ,
        "transpIE" => $dest->IE,
        "transpxNome" => $dest->xNome,
        "transpCEP" => $dest->CEP,
        "transpxLgr" => $dest->xLgr,
        "transpnro" => $dest->nro,
        "transpxBairro" => $dest->xBairro,
        "transpxMun" => $dest->xMun,
        "transpcMun" => $dest->cMun,
        "transpUF" => $dest->UF
    );

endif;

$total = array(
    "vBCSTnf" => '0',
    "vSTnf" => '0',
    "vProdnf" => $movimentacao->valortotal,
    "vFretenf" => '0',
    "vSegnf" => '0',
    "vDescnf" => $movimentacao->desconto,
    "vIInf" => '0',
    "vIPInf" => '0',
    "vPISnf" => '0',
    "vCOFINSnf" => '0',
    "vOutronf" => '0',
    "vNF" => number_format($movimentacao->valortotal - $movimentacao->desconto, 2, '.', '')
);

$insnfe = array_merge($nfe, $cliente, $tranportadora, $total);
$filternfe = array_filter($insnfe);

$total = count($filternfe);
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'nfe');
$sql = $crud->SQLinsert('nfe', $filternfe, $total);
$retorno = $crud->SqlID($sql);
//echo $sql;
$nfeid = $retorno;

$valorTotalProdutos = 0;
foreach ($produtos as $produto) {
    $valorTotalProdutos += $produto->valorbruto;
}

$descTotal = $movimentacao->desconto;
$descRestante = $descTotal;

$porcentagemProdTotal = [];

foreach ($produtos as $key => $prod) :
    $porcentagemProdTotal[$key] = $prod->valorbruto / $valorTotalProdutos;

    if ($descTotal > 0 && $descRestante > 0) {
        $vDesc = min(number_format(($descTotal * $porcentagemProdTotal[$key]), 2, '.', ''), $descRestante);
        $descRestante -= $vDesc;
    } else {
        $vDesc = 0;
    }

    $prod->desconto = $vDesc;

endforeach;

if ($descRestante > 0) {
    $maiorValor = $produtos[0]->valorbruto;
    $posicaoMaior = 0;
    foreach ($produtos as $key => $prod) {
        if ($prod->valorbruto > $maiorValor) {
            $maiorValor = $prod->valorbruto;
            $posicaoMaior = $key;
        }
    }
    $produtos[$posicaoMaior]->desconto += number_format($descRestante, 2, '.', '');
}
foreach ($produtos as $prod) :

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'itmovsai');
    $sql = "SELECT produto, codproduto from estoqueprodutos where codproduto = '$prod->produto'";
    $arrayParam = '';
    $estoqueproduto = $crud->getSQLGeneric($sql, $arrayParam, false);

    $pdo = Conexao::getInstance();
    $crud = Crud:: getInstance($pdo, 'tributacaoprodutos');
    $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '" . $_SESSION['Empresa'] . "'";
    $arrayParam = '';
    $proddados = $crud->getSQLGeneric($sql, $arrayParam, true);

    if (count($proddados) > 0) :
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud:: getInstance($pdo, 'itmovsai');
        $sql = "SELECT * FROM produtos 
        inner join tributacaoprodutos on produtos.codigo = tributacaoprodutos.produto 
        where produtos.codigo = '" . $estoqueproduto->produto . "' 
        AND tributacaoprodutos.empresa = '1'";
        $arrayParam = '';
        $proddados = $crud->getSQLGeneric($sql, $arrayParam, false);
    endif;

//    echo $sql;

    if ($proddados->tributacaotipo === 'O') :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from produtos_icms WHERE produto = '" . $estoqueproduto->produto . "' and uf = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);
    else :
        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'tributacaoprodutos');
        $sql = "SELECT * from fiscalicmsinterestadual WHERE origem = '" . $emitente->UF . "' and destino = '" . $dest->UF . "'";
        $arrayParam = '';
        $produtos_icms = $crud->getSQLGeneric($sql, $arrayParam, false);

//        echo $sql;
    endif;

//    print_r($produtos_icms);

    if ($emitente->UF != $dest->UF) :
        $cfop = $proddados->cfopuf;
    else :
        $cfop = $proddados->cfop;
    endif;

    if ($produtos_icms->icms > 4) :
        $origem = '0';
    else :
        $origem = '1';
    endif;

    if ($emitente->regimetributario == '1') :
        $CST = VerificaCST($dest->CNPJ, $dest->IE);

    else :
        $CST = $proddados->cst;
    endif;

    if ($_GET['tipoem'] == 'MAn') :
        $cfop = $proddados->cfopmanifesto;
        $CST = '400';
        $origem = '0';
//        echo $cfop;
    endif;

    if ($porcentagem < 100) :
        $vr = $prod->preco * ($porcentagem / 100);

        if ($parametros->arredondamento_prod != '') :
            $vr = intval($vr) . '.' . $parametros->arredondamento_prod;
        endif;

        $prod->preco = $vr;
        $prod->valorbruto = $prod->quantidade * $vr;

    endif;

    $vProdnf = $vProdnf + $prod->valorbruto;
    $totaldesc = $totaldesc + $prod->desconto;
    $totalpecas = $totalpecas + $prod->quantidade;
    $produtonfe = array(
        "cProd" => $prod->produto,
        "NFe" => $nfeid,
        "xProd" => $proddados->descricao,
        "uCom" => $proddados->unidade,
        "vProd" => $prod->preco,
        "NCM" => $proddados->ncm,
        "CST" => $CST,
        "modBC" => $proddados->modBC,
        "qtd" => $prod->quantidade,
        "valortotal" => $prod->valorbruto,
        "orig" => $origem,
        "CFOP" => $cfop,
        "vDesc" => $prod->desconto
    );
//    echo $proddados->pICMS;
    if ($proddados->tributado == 'S') :
        if ($CST == '20') :

            $pRedBC = $proddados->pRedBC;
            if ($pRedBC > 0) :
                $vBCICMS = $vBCICMS + (Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc) * ($pRedBC / 100));
                $vBCICMSProd = Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc) * ($pRedBC / 100);
                $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $vBCICMSProd, $vDesc);
            else :
                $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc);
                $vBCICMSProd = Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc);
                $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc);
            endif;

            $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc);
            $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc);

        else :
            $vBCICMS = $vBCICMS + Retornavalor($produtos_icms->icms, $prod->valorbruto, $vDesc);
            $vICMS = $vICMS + RetornaImp($produtos_icms->icms, $prod->valorbruto, $vDesc);
            $vPIS = $vPIS + RetornaImp($proddados->pPIS, $prod->valorbruto, $vDesc);
            $vCOFINS = $vCOFINS + RetornaImp($proddados->vCOFINS, $prod->valorbruto, $vDesc);
        endif;
        $prodnfeimp = array(
            "pICMS" => $produtos_icms->icms,
            "vBC" => Retornavalor($produtos_icms->icms, $prod->valorbruto, $prod->desconto),
            "vICMS" => RetornaImp($produtos_icms->icms, $prod->valorbruto, $prod->desconto),
            "pRedBC" => "0",
            "CSTIPI" => $proddados->cstipi,
            "pIPI" => $proddados->pIPI,
            "vBCIPI" => Retornavalor($proddados->pIPI, $prod->valorbruto, $prod->desconto),
            "vIPI" => RetornaImp($proddados->pIPI, $prod->valorbruto, $prod->desconto),
            "CSTPIS" => $proddados->cstpis,
            "pPIS" => $proddados->pPIS,
            "vBCPIS" => Retornavalor($proddados->pPIS, $prod->valorbruto, $prod->desconto),
            "vPIS" => RetornaImp($proddados->pPIS, $prod->valorbruto, $prod->desconto),
            "CSTCOFINS" => $proddados->cstcofins,
            "pCOFINS" => $proddados->pCOFINS,
            "vBCCOFINS" => Retornavalor($proddados->pCOFINS, $prod->valorbruto, $prod->desconto),
            "vCOFINS" => RetornaImp($proddados->pCOFINS, $prod->valorbruto, $prod->desconto),
        );
    else :
        $vBCICMS = $vBCICMS + 0;
        $vICMS = $vICMS + 0;
        $vPIS = $vPIS + 0;
        $vCOFINS = $vCOFINS + 0;
        $prodnfeimp = array(
            "CSTIPI" => $proddados->cstipi,
            "CSTPIS" => $proddados->cstpis,
            "CSTCOFINS" => $proddados->cstcofins,
        );
    endif;

    if ($emitente->tokenibpt != '') :
        $token = $emitente->tokenibpt;
        $cnpj = $emitente->CNPJ;

        $ncm = $proddados->ncm; //coloque o NCM do produto
        $uf = $emitente->UF; //coloque o estado que deseja saber os dados
        $extarif = 0; //indique o numero da exceção tarifaria, se existir ou deixe como zero
        $codigoInterno = '';
        $descricao = $proddados->descricao;
        $unidadeMedida = $proddados->unidade;
        $valor = $prod->valorbruto;
        $gtin = 'SEM GTIN';
        $ibpt = new Ibpt($cnpj, $token);

        $resp = $ibpt->productTaxes(
                $uf, $ncm, $extarif, $descricao, $unidadeMedida, $valor, $gtin, $codigoInterno
        );

//        $_POST['vTotTrib'] = $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal;
//
//        $_POST['tribFederal'] = $resp->ValorTributoNacional;
//        $_POST['tribEstadual'] = $resp->ValorTributoEstadual;
//        $_POST['tribMunicipal'] = $resp->ValorTributoMunicipal;

        $tribaprox = array(
            "tribFederal" => $resp->ValorTributoNacional,
            "tribEstadual" => $resp->ValorTributoEstadual,
            "tribMunicipal" => $resp->ValorTributoMunicipal,
            "vTotTrib" => $resp->ValorTributoNacional + $resp->ValorTributoEstadual + $resp->ValorTributoMunicipal
        );
    else :
        $tribaprox = array(
            "tribFederal" => '0',
            "tribEstadual" => '0',
            "tribMunicipal" => '0',
            "vTotTrib" => '0'
        );
    endif;

    $prodnfe = array_merge($produtonfe, $prodnfeimp, $tribaprox);
//    $prodnfe = array_filter($prodnfe);

    $total = count($prodnfe);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = $crud->SQLinsert('produtonfe', $prodnfe, $total);
    $retorno = $crud->Sql($sql);

    $item++;

endforeach;

$item = 1;
foreach ($pagmovsaida as $dup) :
//    if ($dup->tiporeceb == 'B') :
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtonfe');
    $sql = "INSERT INTO duplicatanfe(parcela, vencimento, valor, duplicata, nfe, forma) VALUES 
            ('$item', '$dup->dataven', '$dup->valor', '$nNF', '$nfeid', '$dup->tiporeceb')   
            ";
    $retorno = $crud->Sql($sql);
    $item++;

//    echo $sql;
//    endif;
endforeach;

$vNF = $vProdnf - $totaldesc;
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update nfe set vBCnf = '$vBCICMS', vICMSnf = '$vICMS', vPISnf = '$vPIS', vCOFINSnf = '$vCOFINS',
    vProdnf = '$vProdnf', vNF = '$vNF', vDescnf = vDescnf + '$descitem1' ";

if ($_GET['tipoem'] == 'MAn') :
    $sql .= " , qVol = '$totalpecas'";
endif;

$sql .= " where id = '$nfeid' ";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update movimentacao set DocFiscal = '$nfeid' where documento = '" . $documentomov . "' ";
$retorno = $crud->Sql($sql);

$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'produtonfe');
$sql = "update lancamento set titulo = '$nNF', NotaFiscal = '$nfeid' where documento = '" . $documentomov . "'";
$retorno = $crud->Sql($sql);

//echo $sql;

if ($nfeid > 0) :
    $arr = array("nfe" => $nNF, "mensagem" => 'NF-e Gerada com sucesso! Nº ' . $nNF . '');
else :
    $arr = array("nfe" => 0, "mensagem" => "Não foi possivél gerar a NF-e");
endif;

echo json_encode($arr);