<?php

require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";
require_once "../../_class/parametros.php";

function limpar_dados($dados) {
    if (is_array($dados)) {
        // Percorre o array e limpa os valores recursivamente
        foreach ($dados as $chave => $valor) {
            $dados[$chave] = limpar_dados($valor);
        }
    } elseif (is_object($dados)) {
        // Converte o objeto em um array, limpa os valores e reatribui ao objeto
        foreach (get_object_vars($dados) as $chave => $valor) {
            $dados->$chave = limpar_dados($valor);
        }
    } else {
        // Remove espaços em branco no início e no final
        $dados = trim($dados);
        // Remove caracteres problemáticos
        $dados = str_replace(['"', "'", ";", "--"], '', $dados);
    }
    return $dados;
}

$_POST = limpar_dados($_POST);

$_POST['UltimaAlteracao'] = date("Y-m-d H:i:s");

if ($parametros->os == 'S') :
    $placa = $_POST['placa'];
    $marca = $_POST['marca'];
    $modelo = $_POST['modelo'];
    $ano = $_POST['ano'];
    $kmatual = $_POST['kmatual'];

    unset($_POST['placa']);
    unset($_POST['marca']);
    unset($_POST['modelo']);
    unset($_POST['ano']);
    unset($_POST['kmatual']);

endif;

if ($parametros->cheff == 'S') :
    $cep = $_POST['CEP'];
    $xLgr = $_POST['xLgr'];
    $nro = $_POST['nro'];
    $xCpl = $_POST['xCpl'];
    $xBairro = $_POST['xBaiiro'];
    $xMun = $_POST['xMun'];
    $UF = $_POST['UF'];
    $cMun = $_POST['cMun'];
    $obs = $_POST['obsendereco'];

    unset($_POST['CEP']);
    unset($_POST['xLgr']);
    unset($_POST['nro']);
    unset($_POST['xCpl']);
    unset($_POST['xBairro']);
    unset($_POST['xMun']);
    unset($_POST['UF']);
    unset($_POST['cMun']);
    unset($_POST['obsendereco']);
endif;

$_POST['credito'] = 0;

//print_r($_POST);
// Consumindo métodos do CRUD genérico 
// Atribui uma conexão PDO   
$pdo = Conexao::getInstance();
$pdo->beginTransaction();
// Atribui uma instância da classe Crud, passando como parâmetro a conexão PDO e o nome da tabela  
$crud = Crud::getInstance($pdo, 'cliente');
//$retorno = $crud->insertID($_POST);
$total = count($_POST);
$sql = $crud->SQLinsert('cliente', $_POST, $total);
//echo $sql;
$retorno = $crud->SqlID($sql);

if ($retorno > 0) :
    $pdo->commit();
    $msg = 'Cliente Cadastrado com SUCESSO!';
    $id = $retorno;
    $retorno = true;

    if ($parametros->cheff == 'S') :
        for ($index = 0; $index < count($xLgr); $index++) :
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'precoprodutos');
            $sql = "INSERT INTO `endereco`(cliente, xLgr, nro, xBairro, xMun, xCpl, CEP, cMun, obs) 
            VALUES 
            ('$id', '$xLgr[$index]', '$nro[$index]', '$xBairro[$index]', '$xMun[$index]', 
                '$xCpl[$index]', '$CEP[$index]', '$cMun[$index]', '$obs[$index]')";
            $endereco = $crud->Sql($sql);

//            echo $sql;
        endfor;
    endif;
    if ($parametros->os == 'S') :
        for ($index = 0; $index < count($placa); $index++) :
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'precoprodutos');
            $sql = "INSERT INTO `veiculo`(cliente, placa, marca, modelo, ano, kmatual) 
            VALUES 
            ('$id', '".strtoupper($placa[$index])."', '".strtoupper($marca[$index])."', '".strtoupper($modelo[$index])."', '$ano[$index]', 
                '$kmatual[$index]')";
            $endereco = $crud->Sql($sql);
//            echo $sql;
        endfor;
    endif;

else :
    $pdo->rollBack();
    $msg = 'Houve um Erro ao cadastrar o CLIENTE, tente novamente!';
    $retorno = -1;

endif;

$exec = array("mensagem" => $msg, "retorno" => $retorno, "id" => $id);
echo json_encode($exec);

