<?php
require_once "../../_class/Conexao_class.php";
require_once "../../_class/Crud_class.php";

$referencia = $_POST['centrodecustoconta'];
$descricao = $_POST['descricao'];
$pdo = Conexao::getInstance();
$crud = Crud::getInstance($pdo, 'centrodecusto');

if (empty($referencia)) {
    // CENTRO DE CUSTO RAIZ
    $sql = "SELECT * FROM centrodecusto WHERE nivel = '1' ORDER BY sequencia DESC LIMIT 1";
    $dados = $crud->getSQLGeneric($sql, '', FALSE);

    if ($dados) {
        $ultimo = explode('.', $dados->sequencia);
        $novoCodigo = str_pad(intval($ultimo[0]) + 1, 2, "0", STR_PAD_LEFT);
    } else {
        $novoCodigo = '01';
    }

    $sequencianovo = $novoCodigo . '.00.00';
    $nivel = 1;
    $centrocusto = $novoCodigo;
    $subcentrocusto = '00';

} else {
    // CENTRO DE CUSTO FILHO
    $partes = explode('.', $referencia);

    // Completa até 3 partes
    while (count($partes) < 3) {
        $partes[] = '00';
    }

    $nivel = count(array_filter($partes, fn($p) => $p !== '00')) + 1;

    if ($nivel > 3) {
        echo json_encode(["mensagem" => "Limite de níveis atingido", "retorno" => -1]);
        exit;
    }

    // Determina o prefixo para busca
    $prefixo = implode('.', array_slice($partes, 0, $nivel - 1));

    // Busca o último filho existente no nível atual
    $sql = "SELECT sequencia FROM centrodecusto 
            WHERE nivel = '$nivel' AND sequencia LIKE '$prefixo.%' 
            ORDER BY sequencia DESC LIMIT 1";
    $dados = $crud->getSQLGeneric($sql, '', FALSE);

    if ($dados) {
        $ultSeq = explode('.', $dados->sequencia);
        $novoValor = str_pad(intval($ultSeq[$nivel - 1]) + 1, 2, "0", STR_PAD_LEFT);
    } else {
        $novoValor = '01';
    }

    // Atualiza a parte do nível atual
    $partes[$nivel - 1] = $novoValor;

    // Zera as partes seguintes
    for ($i = $nivel; $i < 3; $i++) {
        $partes[$i] = '00';
    }

    $sequencianovo = implode('.', $partes);
    $centrocusto = $partes[0];
    $subcentrocusto = $partes[1];
}

// Inserção no banco
$pdo->beginTransaction();

$dadosInserir = [
    "descricao" => $descricao,
    "sequencia" => $sequencianovo,
    "nivel" => $nivel,
    "centrocusto" => $centrocusto,
    "subcentrocusto" => $subcentrocusto
];

$total = count($dadosInserir);
$sql1 = $crud->SQLinsert('centrodecusto', $dadosInserir, $total);
$retorno = $crud->Sql($sql1);

if (!$retorno) {
    $pdo->rollBack();
    $msg = 'Houve um Erro ao cadastrar o CENTRO DE CUSTO, tente novamente!';
    $retorno = -1;
} else {
    $pdo->commit();
    $msg = 'CENTRO DE CUSTO Cadastrado com SUCESSO!';
}

echo json_encode(["mensagem" => $msg, "retorno" => $retorno]);
