<?php

require_once "../../../_class/Conexao_class.php";
require_once "../../../_class/Crud_class.php";

error_reporting(E_ALL);
ini_set('display_errors', 'On');

function soNumero($str) {
    return preg_replace("/[^0-9]/", "", $str);
}

function VerificaCombinacao($combinacao) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'estoqueprodutos');
    $sql = "SELECT * from estoqueprodutos WHERE codproduto = '" . $combinacao . "'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $total = count($dados);

//    echo $sql;
    if ($total > 0) :
        return 'S';
    else :
        return 'N';
    endif;
}

function retornaVariacao($nivel, $variacao) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itensvariacao');
    $sql = "SELECT sigla from itensvariacao WHERE nivel = '$nivel' AND variacao = '$variacao'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, TRUE);
    $arr = array();
    foreach ($dados as $dados) {
        $arr[] = $dados->sigla;
    }
    return $arr;
}

function RetornaCategoria($categoria) {
    $categoria = trim($categoria);
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itensvariacao');
    $sql = "SELECT * from grupos WHERE descricao = '$categoria'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

//    print_r($dados);
    return $dados->sequencia;
}

function RetornaFornecedor($categoria) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'itensvariacao');
    $sql = "SELECT * from fornecedor WHERE CNPJ = '$categoria'";
    $arrayParam = '';
    $dados = $crud->getSQLGeneric($sql, $arrayParam, false);

    return $dados->fornecedorid;
}

function array_combine_recursive(array $data, $separator = ',') {
    $response = new stdClass();
    $callback = function ($item, $key, $aux) use ($response, $separator) {
//      print_r($aux);
        $aux[2][] = $item;

        if (count($aux[0])) {
            array_walk(array_shift($aux[0]), $aux[1], array($aux[0], $aux[1], $aux[2]));
        } else {
            $response->data[] = implode($separator, $aux[2]);
        }
    };

    $response->data = array();

    array_walk(array_shift($data), $callback, array($data, $callback, array()));

    return $response->data;
}

$arquivo = 'produtos.csv';

$denominador = ';';

$arq = fopen($arquivo, 'r');
$ll = 0;
while (!feof($arq)) :
    for ($i = 0; $i < 1; $i++) :
        if ($conteudo = fgets($arq)) :
            $ll++;
            $linha = explode($denominador, $conteudo);
        endif;

        $cst = '102';
        $cfop = '5102';
        $cfopuf = '6102';

        $precop = 'S';

        $categoria = RetornaCategoria($linha[8]);
        $fornecedor = RetornaFornecedor(soNumero($linha[3]));

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'produto');
        $sql = "INSERT INTO produtos(codigo, ref, descricao, custo, classificacao, unidade, 
            fornecedor, categoria, variacao, tributacao, cst, cstipi, cstcofins, cstpis, origem) values (
               '', '" . $linha[1] . "', '" . $linha[2] . "', '" . $linha[6] . "', '02', '" . $linha[4] . "', 
                    '$fornecedor', '', '', '', '$cst', '', '', '', '0')";
        $retorno = $crud->SqlID($sql);

        $codigo = str_pad($retorno, 6, '0', STR_PAD_LEFT);

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'produto');
        $sql = "update produtos set codigo = '$codigo' where produtosid = '$retorno'";
        $retorno = $crud->Sql($sql);

        echo $sql;
        echo '<Br/>';

        $sql = "INSERT INTO estoqueprodutos(produto, var1, var2, codproduto, ref, qtd1) VALUES 
            ('$codigo', '', '', '$codigo', '$linha[1]', '$linha[5]')";
        $retornoestoque = $crud->Sql($sql);
        echo $sql;
        echo '<br/>';

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoque');
        $sql = "INSERT INTO precoprodutos(produto, tabela, valor) VALUES 
            ('$codigo', '1', '" . $linha[7] . "')";
        $retorno = $crud->Sql($sql);
        echo $sql;
        echo '<br/>';

        $pdo = Conexao::getInstance();
        $crud = Crud::getInstance($pdo, 'estoque');
        $sql = "INSERT INTO tributacaoprodutos(produto, ncm, cfop, cfopuf) VALUES 
            ('$codigo', '00000000', '$cfop', '$cfopuf')";
        $retornotributacao = $crud->Sql($sql);
        echo $sql;
        echo '<br/>';

        if ($categoria !== '') :
            $pdo = Conexao::getInstance();
            $crud = Crud::getInstance($pdo, 'estoque');
            $sql = "INSERT INTO grupoprodutos(produto, grupo) VALUES 
            ('$codigo', '$categoria')";
            $retornotributacao = $crud->Sql($sql);
            echo $sql;
            echo '<br/>';
        endif;

        $linha = array();
    endfor;
endwhile;

if ($retorno) :
    $msg = "Nota Fiscal Importada com sucesso!";
    $status = "ok";
else :
    $msg = "Houve um erro ao importar NF-e!";
    $status = "erro";
endif;
$arr = array("msg" => $msg, "status" => $status);
$json = json_encode($arr);
echo $json;

//
//TRUNCATE `estoqueprodutos`;
//TRUNCATE `produtos`;
//TRUNCATE `tributacaoprodutos`;
//TRUNCATE `precoprodutos`;
//TRUNCATE `vinculacaoprodutos`;
//TRUNCATE `grupoprodutos`;