<?php

require_once "../../../_class/Conexao_class.php";
require_once "../../../_class/Crud_class.php";

error_reporting(E_ALL);
ini_set('display_errors', 'On');

function retornaCodigo($ref) {
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtos');
    $sql = "SELECT codigo FROM produtos WHERE ref = '$ref'";
    $dados = $crud->getSQLGeneric($sql, '', false);
    return $dados->codigo ?? null;
}

$arquivo = 'vendas.csv';
$denominador = ';';
$retorno = false;

if (!file_exists($arquivo)) {
    echo json_encode(["msg" => "Arquivo não encontrado", "status" => "erro"]);
    exit;
}

$arq = fopen($arquivo, 'r');
$linhaAtual = 0;

while (($conteudo = fgets($arq)) !== false) {
    $linhaAtual++;
    if ($linhaAtual === 1) continue; // Ignora cabeçalho

    $linha = explode($denominador, trim($conteudo));
    if (count($linha) < 13) continue;

    $linha[0] = substr($linha[0], 0,16);
    $data = parseDate($linha[0], "d/m/Y");
    $hora = parseDate($linha[0], "H:i");
    $doc_empresa = $linha[1];
    $ref_produto = $linha[12];
    $preco = abs($linha[6]);
    $quantidade = abs($linha[7]);

    if (!$data || !$hora || !$doc_empresa || !$ref_produto) continue;

    $pdo = Conexao::getInstance();

    // Verifica se a movimentação já existe
    $pdo = Conexao::getInstance();
    $crud = Crud::getInstance($pdo, 'produtos');
    $sql = "SELECT documento FROM movimentacao WHERE doc_empresa = '$doc_empresa' and empresa = '3'";
    $mov = $crud->getSQLGeneric($sql, '', false);

    if (!empty($mov) && isset($mov->documento)) {
        $idMov = $mov->documento;
    } else {
        // Insere nova movimentação
        $crud = Crud::getInstance($pdo, 'movimentacoes');
        $sql = "INSERT INTO movimentacao(data, para, tbpreco, vendedor, cliente, tipo, hora, valorpago, situacao, doc_empresa, empresa)
                VALUES ('$data', 'C', '1', '1', '1', 'S', '$hora', '0', 'F', '$doc_empresa', '3')";
            
        $idMov = $crud->SqlID($sql);
      //  echo $sql;
    //    echo '<br/>';
    }



    // Insere o item na movimentação
    $codigoProduto = retornaCodigo($ref_produto);
    if (!$codigoProduto) continue;

    $total = $preco * $quantidade;
    $item = 1; // ou gerar sequencial se necessário

    $crudItem = Crud::getInstance($pdo, 'itmovimentacao');
    $sqlItem = "INSERT INTO itmovimentacao(documento, produto, preco, quantidade, valorbruto, valorliquido, item, cancelado)
                VALUES ('$idMov', '$codigoProduto', '$preco', '$quantidade', '$total', '$total', '1', 'N')";
   $item = $crudItem->Sql($sqlItem);

    $retorno = true;
}

fclose($arq);

$msg = $retorno ? "Notas importadas com sucesso!" : "Nenhuma nota foi importada.";
$status = $retorno ? "ok" : "erro";

echo json_encode(["msg" => $msg, "status" => $status]);
