<?php

require_once "../../../_class/Conexao_class.php";
require_once "../../../_class/Crud_class.php";

error_reporting(E_ALL);
ini_set('display_errors', 'On');

$arquivo = 'produtos_2025-07-17-15-06-30.csv';
$denominador = ';';

function limparValor($valor) {
    return str_replace(['"', "\r", "\n", "\t"], '', trim($valor));
}

$arq = fopen($arquivo, 'r');
$header = fgetcsv($arq, 0, $denominador); // pula o cabeçalho

while (!feof($arq)) {
    $linha = fgetcsv($arq, 0, $denominador);
    if (!$linha || count($linha) < 14)
        continue;

    // Campos
    $ref = limparValor($linha[1] ?? '');
    $descricao = limparValor($linha[2] ?? '');
    $ncm = limparValor($linha[4] ?? '');
    $custo = limparValor($linha[11] ?? '0'); // Preço de Compra
    $preco = limparValor($linha[6] ?? '0');  // Preço Venda
    $estoque = limparValor($linha[10] ?? '0');  // Estoque
    $id = limparValor($linha[0] ?? '');
    $nomeFornecedor = limparValor($linha[13] ?? '');

    $custo = str_replace(',', '.', $custo);
    $preco = str_replace(',', '.', $preco);

    if (empty($descricao)) continue;

    $pdo = Conexao::getInstance();

    // Verifica e insere fornecedor, se necessário
    $crudFornecedor = Crud::getInstance($pdo, 'fornecedor');
    $sqlFornecedor = "SELECT fornecedorid FROM fornecedor WHERE xNome = :xNome AND excluido = 'N' LIMIT 1";
    $stmt = $pdo->prepare($sqlFornecedor);
    $stmt->bindValue(':xNome', $nomeFornecedor);
    $stmt->execute();
    $fornecedor = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($fornecedor) {
        $fornecedorId = $fornecedor['fornecedorid'];
    } else {
        $sqlInsertFornecedor = "INSERT INTO fornecedor (xNome) VALUES (:xNome)";
        $stmt = $pdo->prepare($sqlInsertFornecedor);
        $stmt->bindValue(':xNome', $nomeFornecedor);
        $stmt->execute();
        $fornecedorId = $pdo->lastInsertId();
    }

    // Inserção produto
    $crudProduto = Crud::getInstance($pdo, 'produtos');
    $sqlProduto = "INSERT INTO produtos(ref, codigo, descricao, custo, unidade, classificacao, garantia, fiscal, codinterno, fornecedor) 
                   VALUES ('$ref', '', '$descricao', '$custo', 'UN', '02', '', 'N', '$id', '$fornecedorId')";
    $codigo1 = $crudProduto->SqlID($sqlProduto);
    $codigo = str_pad($codigo1, 6, '0', STR_PAD_LEFT);
    $crudProduto->Sql("UPDATE produtos SET codigo = '$codigo' WHERE produtosid = '$codigo1'");

    // Estoque
    $crudEstoque = Crud::getInstance($pdo, 'estoqueprodutos');
    $crudEstoque->Sql("INSERT INTO estoqueprodutos(ref, produto, var1, var2, codproduto, barras, qtd2, fiscal) 
                       VALUES ('$ref', '$codigo', '', '', '$codigo', '', '$estoque', 'N')");

    // Tributação
    $crudTrib = Crud::getInstance($pdo, 'tributacaoprodutos');
    $crudTrib->Sql("INSERT INTO tributacaoprodutos(produto, ncm, cest, cfop, cfopuf, empresa, cst) 
                    VALUES ('$codigo', '$ncm', '', '5102', '6102', '1', '102')");

    // Preço
    $crudPreco = Crud::getInstance($pdo, 'precoprodutos');
    $crudPreco->Sql("INSERT INTO precoprodutos(produto, tabela, valor) 
                     VALUES ('$codigo', '1', '$preco')");
}

fclose($arq);

echo json_encode([
    "msg" => "Importação concluída com sucesso!",
    "status" => "ok"
]);
